/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.converters.BooleanConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineJoin;
import javafx.util.Duration;

public class LineChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart.Series, DoubleProperty> seriesYMultiplierMap = new HashMap<XYChart.Series, DoubleProperty>();
    private Legend legend = new Legend();
    private Timeline dataRemoveTimeline;
    private XYChart.Series<X, Y> seriesOfDataRemoved = null;
    private XYChart.Data<X, Y> dataItemBeingRemoved = null;
    private FadeTransition fadeSymbolTransition = null;
    private Map<XYChart.Data<X, Y>, Double> XYValueMap = new HashMap<XYChart.Data<X, Y>, Double>();
    private Timeline seriesRemoveTimeline = null;
    private BooleanProperty createSymbols = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            for (int i = 0; i < LineChart.this.getData().size(); ++i) {
                XYChart.Series series = (XYChart.Series)LineChart.this.getData().get(i);
                for (int j = 0; j < series.getData().size(); ++j) {
                    XYChart.Data data = (XYChart.Data)series.getData().get(j);
                    Node node = data.getNode();
                    if (this.get() && node == null) {
                        node = LineChart.this.createSymbol(series, LineChart.this.getData().indexOf(series), data, j);
                        LineChart.this.getPlotChildren().add(node);
                        continue;
                    }
                    if (this.get() || node == null) continue;
                    LineChart.this.getPlotChildren().remove(node);
                    node = null;
                    data.setNode(null);
                }
            }
            LineChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return LineChart.this;
        }

        @Override
        public String getName() {
            return "createSymbols";
        }

        @Override
        public CssMetaData<LineChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.CREATE_SYMBOLS;
        }
    };

    public final boolean getCreateSymbols() {
        return this.createSymbols.getValue();
    }

    public final void setCreateSymbols(boolean bl) {
        this.createSymbols.setValue(bl);
    }

    public final BooleanProperty createSymbolsProperty() {
        return this.createSymbols;
    }

    public LineChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public LineChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> observableList) {
        super(axis, axis2);
        this.setLegend(this.legend);
        this.setData(observableList);
    }

    @Override
    protected void updateAxisRange() {
        Axis axis = this.getXAxis();
        Axis axis2 = this.getYAxis();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if (axis.isAutoRanging()) {
            arrayList = new ArrayList();
        }
        if (axis2.isAutoRanging()) {
            arrayList2 = new ArrayList();
        }
        if (arrayList != null || arrayList2 != null) {
            for (XYChart.Series series : this.getData()) {
                for (XYChart.Data data : series.getData()) {
                    if (arrayList != null) {
                        arrayList.add(data.getXValue());
                    }
                    if (arrayList2 == null) continue;
                    arrayList2.add(data.getYValue());
                }
            }
            if (arrayList != null && (arrayList.size() != 1 || this.getXAxis().toNumericValue(arrayList.get(0)) != 0.0)) {
                axis.invalidateRange(arrayList);
            }
            if (arrayList2 != null && (arrayList2.size() != 1 || this.getYAxis().toNumericValue(arrayList2.get(0)) != 0.0)) {
                axis2.invalidateRange(arrayList2);
            }
        }
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int n, XYChart.Data<X, Y> data) {
        Node node = this.createSymbol(series, this.getData().indexOf(series), data, n);
        if (this.shouldAnimate()) {
            if (this.dataRemoveTimeline != null && this.dataRemoveTimeline.getStatus().equals((Object)Animation.Status.RUNNING) && this.seriesOfDataRemoved == series) {
                this.dataRemoveTimeline.stop();
                this.dataRemoveTimeline = null;
                this.getPlotChildren().remove(this.dataItemBeingRemoved.getNode());
                this.removeDataItemFromDisplay(this.seriesOfDataRemoved, this.dataItemBeingRemoved);
                this.seriesOfDataRemoved = null;
                this.dataItemBeingRemoved = null;
            }
            boolean bl = false;
            if (n > 0 && n < series.getData().size() - 1) {
                bl = true;
                XYChart.Data data2 = (XYChart.Data)series.getData().get(n - 1);
                XYChart.Data data3 = (XYChart.Data)series.getData().get(n + 1);
                if (data2 != null && data3 != null) {
                    double d = this.getXAxis().toNumericValue(data2.getXValue());
                    double d2 = this.getYAxis().toNumericValue(data2.getYValue());
                    double d3 = this.getXAxis().toNumericValue(data3.getXValue());
                    double d4 = this.getYAxis().toNumericValue(data3.getYValue());
                    double d5 = this.getXAxis().toNumericValue(data.getXValue());
                    if (d5 > d && d5 < d3) {
                        double d6 = (d4 - d2) / (d3 - d) * d5 + (d3 * d2 - d4 * d) / (d3 - d);
                        data.setCurrentY(this.getYAxis().toRealValue(d6));
                        data.setCurrentX(this.getXAxis().toRealValue(d5));
                    } else {
                        double d7 = (d3 + d) / 2.0;
                        double d8 = (d4 + d2) / 2.0;
                        data.setCurrentX(this.getXAxis().toRealValue(d7));
                        data.setCurrentY(this.getYAxis().toRealValue(d8));
                    }
                }
            } else if (n == 0 && series.getData().size() > 1) {
                bl = true;
                data.setCurrentX(((XYChart.Data)series.getData().get(1)).getXValue());
                data.setCurrentY(((XYChart.Data)series.getData().get(1)).getYValue());
            } else if (n == series.getData().size() - 1 && series.getData().size() > 1) {
                bl = true;
                int n2 = series.getData().size() - 2;
                data.setCurrentX(((XYChart.Data)series.getData().get(n2)).getXValue());
                data.setCurrentY(((XYChart.Data)series.getData().get(n2)).getYValue());
            } else if (node != null) {
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(500.0), node);
                fadeTransition.setToValue(1.0);
                fadeTransition.play();
            }
            if (node != null) {
                this.getPlotChildren().add(node);
            }
            if (bl) {
                this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentYProperty(), data.getCurrentY()), new KeyValue(data.currentXProperty(), data.getCurrentX())), new KeyFrame(Duration.millis(700.0), new KeyValue(data.currentYProperty(), data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(data.currentXProperty(), data.getXValue(), Interpolator.EASE_BOTH)));
            }
        } else if (node != null) {
            this.getPlotChildren().add(node);
        }
    }

    @Override
    protected void dataItemRemoved(final XYChart.Data<X, Y> data, final XYChart.Series<X, Y> series) {
        final Node node = data.getNode();
        int n = series.getItemIndex(data);
        if (this.shouldAnimate()) {
            this.XYValueMap.clear();
            boolean bl = false;
            if (n > 0 && n < series.getDataSize()) {
                bl = true;
                XYChart.Data data2 = series.begin;
                for (int i = 0; data2 != null && i != n - 1; ++i) {
                    data2 = data2.next;
                }
                XYChart.Data data3 = data2;
                XYChart.Data data4 = data2.next.next;
                if (data3 != null && data4 != null) {
                    double d = this.getXAxis().toNumericValue(data3.getXValue());
                    double d2 = this.getYAxis().toNumericValue(data3.getYValue());
                    double d3 = this.getXAxis().toNumericValue(data4.getXValue());
                    double d4 = this.getYAxis().toNumericValue(data4.getYValue());
                    double d5 = this.getXAxis().toNumericValue(data.getXValue());
                    double d6 = this.getYAxis().toNumericValue(data.getYValue());
                    if (d5 > d && d5 < d3) {
                        double d7 = (d4 - d2) / (d3 - d) * d5 + (d3 * d2 - d4 * d) / (d3 - d);
                        data.setCurrentX(this.getXAxis().toRealValue(d5));
                        data.setCurrentY(this.getYAxis().toRealValue(d6));
                        data.setXValue(this.getXAxis().toRealValue(d5));
                        data.setYValue(this.getYAxis().toRealValue(d7));
                    } else {
                        double d8 = (d3 + d) / 2.0;
                        double d9 = (d4 + d2) / 2.0;
                        data.setCurrentX(this.getXAxis().toRealValue(d8));
                        data.setCurrentY(this.getYAxis().toRealValue(d9));
                    }
                }
            } else if (n == 0 && series.getDataSize() > 1) {
                bl = true;
                Iterator<XYChart.Data<X, Y>> iterator = this.getDisplayedDataIterator(series);
                if (iterator.hasNext()) {
                    XYChart.Data<X, Y> data5 = iterator.next();
                    data.setXValue(data5.getXValue());
                    data.setYValue(data5.getYValue());
                }
            } else if (n == series.getDataSize() - 1 && series.getDataSize() > 1) {
                bl = true;
                int n2 = series.getData().size() - 1;
                data.setXValue(((XYChart.Data)series.getData().get(n2)).getXValue());
                data.setYValue(((XYChart.Data)series.getData().get(n2)).getYValue());
            } else if (node != null) {
                node.setOpacity(0.0);
                this.fadeSymbolTransition = new FadeTransition(Duration.millis(500.0), node);
                this.fadeSymbolTransition.setToValue(0.0);
                this.fadeSymbolTransition.setOnFinished(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent actionEvent) {
                        data.setSeries(null);
                        LineChart.this.getPlotChildren().remove(node);
                        LineChart.this.removeDataItemFromDisplay(series, data);
                    }
                });
                this.fadeSymbolTransition.play();
            }
            if (bl) {
                this.dataRemoveTimeline = this.createDataRemoveTimeline(data, node, series);
                this.seriesOfDataRemoved = series;
                this.dataItemBeingRemoved = data;
                this.dataRemoveTimeline.play();
            }
        } else {
            data.setSeries(null);
            if (node != null) {
                this.getPlotChildren().remove(node);
            }
            this.removeDataItemFromDisplay(series, data);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> data) {
    }

    @Override
    protected void seriesChanged(ListChangeListener.Change<? extends XYChart.Series> change) {
        for (int i = 0; i < this.getDataSize(); ++i) {
            XYChart.Series series = (XYChart.Series)this.getData().get(i);
            Node node = series.getNode();
            if (node == null) continue;
            node.getStyleClass().setAll((String[])new String[]{"chart-series-line", "series" + i, series.defaultColorStyleClass});
        }
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int n) {
        Path path = new Path();
        path.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        series.setNode(path);
        SimpleDoubleProperty simpleDoubleProperty = new SimpleDoubleProperty(this, "seriesYMultiplier");
        this.seriesYMultiplierMap.put(series, simpleDoubleProperty);
        if (this.shouldAnimate()) {
            path.setOpacity(0.0);
            simpleDoubleProperty.setValue(0.0);
        } else {
            simpleDoubleProperty.setValue(1.0);
        }
        this.getPlotChildren().add(path);
        ArrayList<KeyFrame> arrayList = new ArrayList<KeyFrame>();
        if (this.shouldAnimate()) {
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue(path.opacityProperty(), 0), new KeyValue(simpleDoubleProperty, 0)));
            arrayList.add(new KeyFrame(Duration.millis(200.0), new KeyValue(path.opacityProperty(), 1)));
            arrayList.add(new KeyFrame(Duration.millis(500.0), new KeyValue(simpleDoubleProperty, 1)));
        }
        for (int i = 0; i < series.getData().size(); ++i) {
            XYChart.Data data = (XYChart.Data)series.getData().get(i);
            Node node = this.createSymbol(series, n, data, i);
            if (node == null) continue;
            if (this.shouldAnimate()) {
                node.setOpacity(0.0);
            }
            this.getPlotChildren().add(node);
            if (!this.shouldAnimate()) continue;
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue(node.opacityProperty(), 0)));
            arrayList.add(new KeyFrame(Duration.millis(200.0), new KeyValue(node.opacityProperty(), 1)));
        }
        if (this.shouldAnimate()) {
            this.animate(arrayList.toArray(new KeyFrame[arrayList.size()]));
        }
    }

    private void updateDefaultColorIndex(XYChart.Series<X, Y> series) {
        int n = (Integer)this.seriesColorMap.get(series);
        this.colorBits.clear(n);
        series.getNode().getStyleClass().remove(DEFAULT_COLOR + n);
        for (int i = 0; i < series.getData().size(); ++i) {
            Node node = ((XYChart.Data)series.getData().get(i)).getNode();
            if (node == null) continue;
            node.getStyleClass().remove(DEFAULT_COLOR + n);
        }
        this.seriesColorMap.remove(series);
    }

    @Override
    protected void seriesRemoved(final XYChart.Series<X, Y> series) {
        this.updateDefaultColorIndex(series);
        this.seriesYMultiplierMap.remove(series);
        if (this.shouldAnimate()) {
            final ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.add(series.getNode());
            if (this.getCreateSymbols()) {
                for (XYChart.Data data : series.getData()) {
                    arrayList.add(data.getNode());
                }
            }
            KeyValue[] data = new KeyValue[arrayList.size()];
            KeyValue[] keyValueArray = new KeyValue[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                data[i] = new KeyValue(((Node)arrayList.get(i)).opacityProperty(), 1);
                keyValueArray[i] = new KeyValue(((Node)arrayList.get(i)).opacityProperty(), 0);
            }
            this.seriesRemoveTimeline = new Timeline();
            this.seriesRemoveTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, data), new KeyFrame(Duration.millis(900.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    LineChart.this.getPlotChildren().removeAll(arrayList);
                    LineChart.this.removeSeriesFromDisplay(series);
                }
            }, keyValueArray)});
            this.seriesRemoveTimeline.play();
        } else {
            this.getPlotChildren().remove(series.getNode());
            for (XYChart.Data data : series.getData()) {
                this.getPlotChildren().remove(data.getNode());
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    @Override
    protected void layoutPlotChildren() {
        for (int i = 0; i < this.getDataSize(); ++i) {
            XYChart.Series series = (XYChart.Series)this.getData().get(i);
            DoubleProperty doubleProperty = this.seriesYMultiplierMap.get(series);
            boolean bl = true;
            if (!(series.getNode() instanceof Path)) continue;
            Path path = (Path)series.getNode();
            path.getElements().clear();
            XYChart.Data data = series.begin;
            while (data != null) {
                double d = this.getXAxis().getDisplayPosition(data.getCurrentX());
                double d2 = this.getYAxis().getDisplayPosition(this.getYAxis().toRealValue(this.getYAxis().toNumericValue(data.getCurrentY()) * doubleProperty.getValue()));
                if (bl) {
                    bl = false;
                    path.getElements().add(new MoveTo(d, d2));
                } else {
                    path.getElements().add(new LineTo(d, d2));
                }
                Node node = data.getNode();
                if (node != null) {
                    double d3 = node.prefWidth(-1.0);
                    double d4 = node.prefHeight(-1.0);
                    node.resizeRelocate(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
                }
                data = data.next;
            }
        }
    }

    @Override
    void dataBeingRemovedIsAdded(XYChart.Data data, XYChart.Series series) {
        Node node;
        if (this.fadeSymbolTransition != null) {
            this.fadeSymbolTransition.setOnFinished(null);
            this.fadeSymbolTransition.stop();
        }
        if (this.dataRemoveTimeline != null) {
            this.dataRemoveTimeline.setOnFinished(null);
            this.dataRemoveTimeline.stop();
        }
        if ((node = data.getNode()) != null) {
            this.getPlotChildren().remove(node);
        }
        data.setSeries(null);
        this.removeDataItemFromDisplay(series, data);
        Double d = this.XYValueMap.get(data);
        if (d != null) {
            data.setYValue(d);
            data.setCurrentY(d);
        }
        this.XYValueMap.clear();
    }

    @Override
    void seriesBeingRemovedIsAdded(XYChart.Series<X, Y> series) {
        if (this.seriesRemoveTimeline != null) {
            this.seriesRemoveTimeline.setOnFinished(null);
            this.seriesRemoveTimeline.stop();
            this.getPlotChildren().remove(series.getNode());
            for (XYChart.Data data : series.getData()) {
                this.getPlotChildren().remove(data.getNode());
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    private Timeline createDataRemoveTimeline(final XYChart.Data<X, Y> data, final Node node, final XYChart.Series<X, Y> series) {
        Timeline timeline = new Timeline();
        this.XYValueMap.put(data, ((Number)data.getYValue()).doubleValue());
        timeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(data.currentYProperty(), data.getCurrentY()), new KeyValue(data.currentXProperty(), data.getCurrentX())), new KeyFrame(Duration.millis(500.0), new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                if (node != null) {
                    LineChart.this.getPlotChildren().remove(node);
                }
                LineChart.this.removeDataItemFromDisplay(series, data);
                LineChart.this.XYValueMap.clear();
            }
        }, new KeyValue(data.currentYProperty(), data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(data.currentXProperty(), data.getXValue(), Interpolator.EASE_BOTH))});
        return timeline;
    }

    private Node createSymbol(XYChart.Series<X, Y> series, int n, XYChart.Data data, int n2) {
        Node node = data.getNode();
        if (node == null && this.getCreateSymbols()) {
            node = new StackPane();
            data.setNode(node);
        }
        if (node != null) {
            node.getStyleClass().addAll((String[])new String[]{"chart-line-symbol", "series" + n, "data" + n2, series.defaultColorStyleClass});
        }
        return node;
    }

    @Override
    protected void updateLegend() {
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (int i = 0; i < this.getData().size(); ++i) {
                XYChart.Series series = (XYChart.Series)this.getData().get(i);
                Legend.LegendItem legendItem = new Legend.LegendItem(series.getName());
                legendItem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-line-symbol", "series" + i, series.defaultColorStyleClass});
                this.legend.getItems().add(legendItem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return LineChart.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<LineChart<?, ?>, Boolean> CREATE_SYMBOLS = new CssMetaData<LineChart<?, ?>, Boolean>("-fx-create-symbols", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(LineChart lineChart) {
                return lineChart.createSymbols == null || !lineChart.createSymbols.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(LineChart lineChart) {
                return (StyleableProperty)((Object)lineChart.createSymbolsProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(XYChart.getClassCssMetaData());
            arrayList.add(CREATE_SYMBOLS);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

