/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.scene.control.GlobalMenuAdapter;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import com.sun.javafx.stage.StageHelper;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class MenuBarSkin
extends BehaviorSkinBase<MenuBar, BehaviorBase<MenuBar>>
implements TraverseListener {
    private final HBox container;
    private Menu openMenu;
    private MenuBarButton openMenuButton;
    private int focusedMenuIndex = -1;
    private TraversalEngine engine;
    private Direction direction;
    private static WeakHashMap<Stage, MenuBarSkin> systemMenuMap;
    private static List<MenuBase> wrappedDefaultMenus;
    private static Stage currentMenuBarStage;
    private List<MenuBase> wrappedMenus;
    private WeakEventHandler<KeyEvent> weakSceneKeyEventHandler;
    private WeakEventHandler<MouseEvent> weakSceneMouseEventHandler;
    private WeakChangeListener<Boolean> weakWindowFocusListener;
    private WeakChangeListener<Window> weakWindowSceneListener;
    private EventHandler<KeyEvent> keyEventHandler;
    private EventHandler<MouseEvent> mouseEventHandler;
    private ChangeListener<Boolean> menuBarFocusedPropertyListener;
    Runnable firstMenuRunnable = new Runnable(){

        @Override
        public void run() {
            if (MenuBarSkin.this.container.getChildren().size() > 0 && MenuBarSkin.this.container.getChildren().get(0) instanceof MenuButton) {
                if (MenuBarSkin.this.focusedMenuIndex != 0) {
                    MenuBarSkin.this.unSelectMenus();
                    MenuBarSkin.this.focusedMenuIndex = 0;
                    MenuBarSkin.this.openMenuButton = (MenuBarButton)MenuBarSkin.this.container.getChildren().get(0);
                    MenuBarSkin.this.openMenu = (Menu)((MenuBar)MenuBarSkin.this.getSkinnable()).getMenus().get(0);
                    MenuBarSkin.this.openMenuButton.setHover();
                } else {
                    MenuBarSkin.this.unSelectMenus();
                }
            }
        }
    };
    private boolean pendingDismiss = false;
    private EventHandler<ActionEvent> menuActionEventHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent actionEvent) {
            CustomMenuItem customMenuItem;
            if (actionEvent.getSource() instanceof CustomMenuItem && !(customMenuItem = (CustomMenuItem)actionEvent.getSource()).isHideOnClick()) {
                return;
            }
            MenuBarSkin.this.unSelectMenus();
        }
    };

    public static void setDefaultSystemMenuBar(final MenuBar menuBar) {
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            wrappedDefaultMenus.clear();
            for (Menu menu : menuBar.getMenus()) {
                wrappedDefaultMenus.add(GlobalMenuAdapter.adapt(menu));
            }
            menuBar.getMenus().addListener(new ListChangeListener<Menu>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends Menu> change) {
                    wrappedDefaultMenus.clear();
                    for (Menu menu : menuBar.getMenus()) {
                        wrappedDefaultMenus.add(GlobalMenuAdapter.adapt(menu));
                    }
                }
            });
        }
    }

    private static void setSystemMenu(Stage stage) {
        List<MenuBase> list;
        if (stage != null && stage.isFocused()) {
            while (stage != null && stage.getOwner() instanceof Stage && ((list = systemMenuMap.get(stage)) == null || ((MenuBarSkin)((Object)list)).wrappedMenus == null)) {
                stage = (Stage)stage.getOwner();
            }
        } else {
            stage = null;
        }
        if (stage != currentMenuBarStage) {
            MenuBarSkin menuBarSkin;
            list = null;
            if (stage != null && (menuBarSkin = systemMenuMap.get(stage)) != null) {
                list = menuBarSkin.wrappedMenus;
            }
            if (list == null) {
                list = wrappedDefaultMenus;
            }
            Toolkit.getToolkit().getSystemMenu().setMenus(list);
            currentMenuBarStage = stage;
        }
    }

    private static void initSystemMenuBar() {
        systemMenuMap = new WeakHashMap();
        final InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                MenuBarSkin.setSystemMenu((Stage)((ReadOnlyProperty)observable).getBean());
            }
        };
        ObservableList<Stage> observableList = StageHelper.getStages();
        for (Stage stage : observableList) {
            stage.focusedProperty().addListener(invalidationListener);
        }
        observableList.addListener(new ListChangeListener<Stage>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Stage> change) {
                while (change.next()) {
                    for (Stage stage : change.getRemoved()) {
                        stage.focusedProperty().removeListener(invalidationListener);
                    }
                    for (Stage stage : change.getAddedSubList()) {
                        stage.focusedProperty().addListener(invalidationListener);
                        MenuBarSkin.setSystemMenu(stage);
                    }
                }
            }
        });
    }

    EventHandler<KeyEvent> getKeyEventHandler() {
        return this.keyEventHandler;
    }

    public MenuBarSkin(final MenuBar menuBar) {
        super(menuBar, new BehaviorBase<MenuBar>(menuBar, Collections.EMPTY_LIST));
        String string;
        Object object2;
        this.container = new HBox();
        this.container.getStyleClass().add("container");
        this.getChildren().add(this.container);
        this.keyEventHandler = new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent keyEvent) {
                if (MenuBarSkin.this.openMenu != null) {
                    switch (keyEvent.getCode()) {
                        case LEFT: {
                            boolean bl;
                            boolean bl2 = bl = menuBar.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
                            if (menuBar.getScene().getWindow().isFocused()) {
                                if (MenuBarSkin.this.openMenu == null) {
                                    return;
                                }
                                if (!MenuBarSkin.this.openMenu.isShowing()) {
                                    if (bl) {
                                        MenuBarSkin.this.selectNextMenu();
                                    } else {
                                        MenuBarSkin.this.selectPrevMenu();
                                    }
                                    keyEvent.consume();
                                    return;
                                }
                                if (bl) {
                                    MenuBarSkin.this.showNextMenu();
                                } else {
                                    MenuBarSkin.this.showPrevMenu();
                                }
                            }
                            keyEvent.consume();
                            break;
                        }
                        case RIGHT: {
                            boolean bl;
                            boolean bl3 = bl = menuBar.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
                            if (menuBar.getScene().getWindow().isFocused()) {
                                if (MenuBarSkin.this.openMenu == null) {
                                    return;
                                }
                                if (!MenuBarSkin.this.openMenu.isShowing()) {
                                    if (bl) {
                                        MenuBarSkin.this.selectPrevMenu();
                                    } else {
                                        MenuBarSkin.this.selectNextMenu();
                                    }
                                    keyEvent.consume();
                                    return;
                                }
                                if (bl) {
                                    MenuBarSkin.this.showPrevMenu();
                                } else {
                                    MenuBarSkin.this.showNextMenu();
                                }
                            }
                            keyEvent.consume();
                            break;
                        }
                        case DOWN: {
                            if (!menuBar.getScene().getWindow().isFocused() || MenuBarSkin.this.focusedMenuIndex == -1 || MenuBarSkin.this.openMenu == null) break;
                            MenuBarSkin.this.openMenu = (Menu)((MenuBar)MenuBarSkin.this.getSkinnable()).getMenus().get(MenuBarSkin.this.focusedMenuIndex);
                            if (!MenuBarSkin.this.isMenuEmpty((Menu)((MenuBar)MenuBarSkin.this.getSkinnable()).getMenus().get(MenuBarSkin.this.focusedMenuIndex))) {
                                MenuBarSkin.this.openMenu.show();
                            }
                            keyEvent.consume();
                            break;
                        }
                        case ESCAPE: {
                            MenuBarSkin.this.unSelectMenus();
                            keyEvent.consume();
                            break;
                        }
                    }
                }
            }
        };
        this.menuBarFocusedPropertyListener = new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    MenuBarSkin.this.unSelectMenus();
                    MenuBarSkin.this.focusedMenuIndex = 0;
                    MenuBarSkin.this.openMenuButton = (MenuBarButton)MenuBarSkin.this.container.getChildren().get(0);
                    MenuBarSkin.this.openMenu = (Menu)((MenuBar)MenuBarSkin.this.getSkinnable()).getMenus().get(0);
                    MenuBarSkin.this.openMenuButton.setHover();
                } else {
                    MenuBarSkin.this.unSelectMenus();
                }
            }
        };
        this.weakSceneKeyEventHandler = new WeakEventHandler<KeyEvent>(this.keyEventHandler);
        menuBar.getScene().addEventFilter(KeyEvent.KEY_PRESSED, this.weakSceneKeyEventHandler);
        this.mouseEventHandler = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (!MenuBarSkin.this.container.localToScene(MenuBarSkin.this.container.getLayoutBounds()).contains(mouseEvent.getX(), mouseEvent.getY())) {
                    MenuBarSkin.this.unSelectMenus();
                }
            }
        };
        this.weakSceneMouseEventHandler = new WeakEventHandler<MouseEvent>(this.mouseEventHandler);
        menuBar.getScene().addEventFilter(MouseEvent.MOUSE_CLICKED, this.weakSceneMouseEventHandler);
        this.weakWindowFocusListener = new WeakChangeListener<Boolean>(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!bl2.booleanValue()) {
                    MenuBarSkin.this.unSelectMenus();
                }
            }
        });
        if (menuBar.getScene().getWindow() != null) {
            menuBar.getScene().getWindow().focusedProperty().addListener(this.weakWindowFocusListener);
        } else {
            object2 = new ChangeListener<Window>(){

                @Override
                public void changed(ObservableValue<? extends Window> observableValue, Window window, Window window2) {
                    if (window != null) {
                        window.focusedProperty().removeListener(MenuBarSkin.this.weakWindowFocusListener);
                    }
                    if (window2 != null) {
                        window2.focusedProperty().addListener(MenuBarSkin.this.weakWindowFocusListener);
                    }
                }
            };
            this.weakWindowSceneListener = new WeakChangeListener<Window>((ChangeListener<Window>)object2);
            menuBar.getScene().windowProperty().addListener(this.weakWindowSceneListener);
        }
        this.rebuildUI();
        menuBar.getMenus().addListener(new ListChangeListener<Menu>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Menu> change) {
                MenuBarSkin.this.rebuildUI();
            }
        });
        for (Menu object3 : ((MenuBar)this.getSkinnable()).getMenus()) {
            object3.visibleProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    MenuBarSkin.this.rebuildUI();
                }
            });
        }
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            menuBar.useSystemMenuBarProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    MenuBarSkin.this.rebuildUI();
                }
            });
        }
        object2 = (string = System.getProperty("os.name")) != null && string.startsWith("Mac") ? KeyCombination.keyCombination("ctrl+F10") : KeyCombination.keyCombination("F10");
        ((MenuBar)this.getSkinnable()).getScene().getAccelerators().put((KeyCombination)object2, this.firstMenuRunnable);
        this.engine = new TraversalEngine((Parent)((Object)this.getSkinnable()), false){

            @Override
            public void trav(Node node, Direction direction) {
                MenuBarSkin.this.direction = direction;
                super.trav(node, direction);
            }
        };
        this.engine.addTraverseListener(this);
        ((MenuBar)this.getSkinnable()).setImpl_traversalEngine(this.engine);
        menuBar.sceneProperty().addListener(new ChangeListener<Scene>((KeyCombination)object2){
            final /* synthetic */ KeyCombination val$acceleratorKeyCombo;
            {
                this.val$acceleratorKeyCombo = keyCombination;
            }

            @Override
            public void changed(ObservableValue<? extends Scene> observableValue, Scene scene, Scene scene2) {
                if (MenuBarSkin.this.weakSceneKeyEventHandler != null && scene != null) {
                    scene.removeEventFilter(KeyEvent.KEY_PRESSED, MenuBarSkin.this.weakSceneKeyEventHandler);
                }
                if (MenuBarSkin.this.weakSceneMouseEventHandler != null && scene != null) {
                    scene.removeEventFilter(MouseEvent.MOUSE_CLICKED, MenuBarSkin.this.weakSceneMouseEventHandler);
                }
                if (scene != null) {
                    scene.getAccelerators().remove(this.val$acceleratorKeyCombo);
                }
                if (scene2 != null) {
                    scene2.getAccelerators().put(this.val$acceleratorKeyCombo, MenuBarSkin.this.firstMenuRunnable);
                }
            }
        });
    }

    MenuButton getNodeForMenu(int n) {
        if (n < this.container.getChildren().size()) {
            return (MenuBarButton)this.container.getChildren().get(n);
        }
        return null;
    }

    int getFocusedMenuIndex() {
        return this.focusedMenuIndex;
    }

    private boolean menusContainCustomMenuItem() {
        for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            if (!this.menuContainsCustomMenuItem(menu)) continue;
            System.err.println("Warning: MenuBar ignored property useSystemMenuBar because menus contain CustomMenuItem");
            return true;
        }
        return false;
    }

    private boolean menuContainsCustomMenuItem(Menu menu) {
        for (MenuItem menuItem : menu.getItems()) {
            if (menuItem instanceof CustomMenuItem && !(menuItem instanceof SeparatorMenuItem)) {
                return true;
            }
            if (!(menuItem instanceof Menu) || !this.menuContainsCustomMenuItem((Menu)menuItem)) continue;
            return true;
        }
        return false;
    }

    private int getMenuBarButtonIndex(MenuBarButton menuBarButton) {
        for (int i = 0; i < this.container.getChildren().size(); ++i) {
            MenuBarButton menuBarButton2 = (MenuBarButton)this.container.getChildren().get(i);
            if (menuBarButton != menuBarButton2) continue;
            return i;
        }
        return -1;
    }

    private void updateActionListeners(Menu menu, boolean bl) {
        for (MenuItem menuItem : menu.getItems()) {
            if (menuItem instanceof Menu) {
                this.updateActionListeners((Menu)menuItem, bl);
                continue;
            }
            if (bl) {
                menuItem.addEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
                continue;
            }
            menuItem.removeEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
        }
    }

    private void rebuildUI() {
        MenuBarButton menuBarButton;
        ((MenuBar)this.getSkinnable()).focusedProperty().removeListener(this.menuBarFocusedPropertyListener);
        for (Menu eventTarget2 : ((MenuBar)this.getSkinnable()).getMenus()) {
            this.updateActionListeners(eventTarget2, false);
        }
        Iterator iterator = this.container.getChildren().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            menuBarButton = (MenuBarButton)node;
            menuBarButton.hide();
            menuBarButton.menu.showingProperty().removeListener(menuBarButton.menuListener);
            menuBarButton.disableProperty().unbind();
            menuBarButton.textProperty().unbind();
            menuBarButton.graphicProperty().unbind();
            menuBarButton.styleProperty().unbind();
            menuBarButton.setSkin(null);
            menuBarButton = null;
        }
        this.container.getChildren().clear();
        if (Toolkit.getToolkit().getSystemMenu().isSupported() && ((MenuBar)this.getSkinnable()).getScene() != null && ((Scene)((Object)(iterator = ((MenuBar)this.getSkinnable()).getScene()))).getWindow() instanceof Stage) {
            Stage stage = (Stage)((Scene)((Object)iterator)).getWindow();
            MenuBarButton menuBarButton2 = menuBarButton = systemMenuMap != null ? systemMenuMap.get(stage) : null;
            if (((MenuBar)this.getSkinnable()).isUseSystemMenuBar() && !this.menusContainCustomMenuItem()) {
                if (menuBarButton != null && (((MenuBar)((SkinBase)((Object)menuBarButton)).getSkinnable()).getScene() == null || ((MenuBar)((SkinBase)((Object)menuBarButton)).getSkinnable()).getScene().getWindow() == null)) {
                    systemMenuMap.remove(stage);
                    menuBarButton = null;
                }
                if (systemMenuMap == null || menuBarButton == null || menuBarButton == this) {
                    if (systemMenuMap == null) {
                        MenuBarSkin.initSystemMenuBar();
                    }
                    if (this.wrappedMenus == null) {
                        this.wrappedMenus = new ArrayList<MenuBase>();
                        systemMenuMap.put(stage, this);
                    } else {
                        this.wrappedMenus.clear();
                    }
                    for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
                        this.wrappedMenus.add(GlobalMenuAdapter.adapt(menu));
                    }
                    currentMenuBarStage = null;
                    MenuBarSkin.setSystemMenu(stage);
                    ((MenuBar)this.getSkinnable()).requestLayout();
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            ((MenuBar)MenuBarSkin.this.getSkinnable()).requestLayout();
                        }
                    });
                    return;
                }
            }
            if (menuBarButton == this) {
                this.wrappedMenus = null;
                systemMenuMap.remove(stage);
                currentMenuBarStage = null;
                MenuBarSkin.setSystemMenu(stage);
            }
        }
        ((MenuBar)this.getSkinnable()).focusedProperty().addListener(this.menuBarFocusedPropertyListener);
        for (final Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            if (!menu.isVisible()) continue;
            menuBarButton = new MenuBarButton(this, menu.getText(), menu.getGraphic());
            menuBarButton.setFocusTraversable(false);
            menuBarButton.getStyleClass().add("menu");
            menuBarButton.setStyle(menu.getStyle());
            menuBarButton.setId(menu.getId());
            menuBarButton.getItems().setAll((Collection<MenuItem>)menu.getItems());
            this.container.getChildren().add(menuBarButton);
            menu.getItems().addListener(new ListChangeListener<MenuItem>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends MenuItem> change) {
                    while (change.next()) {
                        menuBarButton.getItems().removeAll((Collection<?>)change.getRemoved());
                        menuBarButton.getItems().addAll(change.getFrom(), (Collection<MenuItem>)change.getAddedSubList());
                    }
                }
            });
            menu.getStyleClass().addListener(new ListChangeListener<String>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends String> change) {
                    while (change.next()) {
                        for (int i = change.getFrom(); i < change.getTo(); ++i) {
                            menuBarButton.getStyleClass().add((String)menu.getStyleClass().get(i));
                        }
                        for (String string : change.getRemoved()) {
                            menuBarButton.getStyleClass().remove(string);
                        }
                    }
                }
            });
            menu.idProperty().addListener(new ChangeListener<String>(){

                @Override
                public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                    menuBarButton.setId(string2);
                }
            });
            menuBarButton.menuListener = new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (menu.isShowing()) {
                        menuBarButton.show();
                        MenuBarSkin.this.focusedMenuIndex = MenuBarSkin.this.container.getChildren().indexOf(menuBarButton);
                    } else {
                        menuBarButton.hide();
                    }
                }
            };
            menuBarButton.menu = menu;
            menu.showingProperty().addListener(menuBarButton.menuListener);
            menuBarButton.disableProperty().bindBidirectional(menu.disableProperty());
            menuBarButton.textProperty().bind(menu.textProperty());
            menuBarButton.graphicProperty().bind(menu.graphicProperty());
            menuBarButton.styleProperty().bind(menu.styleProperty());
            menuBarButton.getProperties().addListener(new MapChangeListener<Object, Object>(){

                @Override
                public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                    if (change.wasAdded() && "autoHide".equals(change.getKey())) {
                        menuBarButton.getProperties().remove("autoHide");
                        menu.hide();
                    }
                }
            });
            menuBarButton.showingProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (bl2.booleanValue()) {
                        if (MenuBarSkin.this.openMenuButton != null && MenuBarSkin.this.openMenuButton != menuBarButton) {
                            MenuBarSkin.this.openMenuButton.hide();
                        }
                        MenuBarSkin.this.openMenuButton = menuBarButton;
                        MenuBarSkin.this.openMenu = menu;
                        if (!menu.isShowing()) {
                            menu.show();
                        }
                    }
                }
            });
            menuBarButton.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    MenuBarSkin.this.pendingDismiss = menuBarButton.isShowing();
                    if (menuBarButton.getScene().getWindow().isFocused()) {
                        MenuBarSkin.this.openMenu = menu;
                        if (!MenuBarSkin.this.isMenuEmpty(menu)) {
                            MenuBarSkin.this.openMenu.show();
                        }
                        MenuBarSkin.this.focusedMenuIndex = MenuBarSkin.this.getMenuBarButtonIndex(menuBarButton);
                    }
                }
            });
            menuBarButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (menuBarButton.getScene().getWindow().isFocused() && MenuBarSkin.this.pendingDismiss) {
                        MenuBarSkin.this.resetOpenMenu();
                    }
                    MenuBarSkin.this.pendingDismiss = false;
                }
            });
            menuBarButton.setOnMouseEntered((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (menuBarButton.getScene() != null && menuBarButton.getScene().getWindow() != null && menuBarButton.getScene().getWindow().isFocused()) {
                        if (MenuBarSkin.this.openMenuButton != null && MenuBarSkin.this.openMenuButton != menuBarButton) {
                            MenuBarSkin.this.openMenuButton.clearHover();
                            MenuBarSkin.this.openMenuButton = null;
                            MenuBarSkin.this.openMenuButton = menuBarButton;
                        }
                        MenuBarSkin.this.updateFocusedIndex();
                        if (MenuBarSkin.this.openMenu != null && MenuBarSkin.this.openMenu != menu) {
                            MenuBarSkin.this.openMenu.hide();
                            MenuBarSkin.this.openMenu = menu;
                            MenuBarSkin.this.updateFocusedIndex();
                            if (!MenuBarSkin.this.isMenuEmpty(menu)) {
                                MenuBarSkin.this.openMenu.show();
                            }
                        }
                    }
                }
            });
            this.updateActionListeners(menu, true);
        }
        ((MenuBar)this.getSkinnable()).requestLayout();
    }

    private boolean isMenuEmpty(Menu menu) {
        boolean bl = true;
        if (menu != null) {
            for (MenuItem menuItem : menu.getItems()) {
                if (menuItem == null || !menuItem.isVisible()) continue;
                bl = false;
            }
        }
        return bl;
    }

    private void resetOpenMenu() {
        if (this.openMenu != null) {
            this.openMenu.hide();
            this.openMenu = null;
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.clearHover();
            this.openMenuButton = null;
            this.focusedMenuIndex = -1;
        }
    }

    private void unSelectMenus() {
        this.clearMenuButtonHover();
        if (this.focusedMenuIndex == -1) {
            return;
        }
        if (this.openMenu != null) {
            this.openMenu.hide();
            this.openMenu = null;
        }
        if (this.openMenuButton != null) {
            this.openMenuButton.clearHover();
            this.openMenuButton = null;
        }
        this.focusedMenuIndex = -1;
    }

    private void selectNextMenu() {
        Menu menu = this.findNextSibling();
        if (menu != null && this.focusedMenuIndex != -1) {
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.setHover();
            this.openMenu = menu;
        }
    }

    private void selectPrevMenu() {
        Menu menu = this.findPreviousSibling();
        if (menu != null && this.focusedMenuIndex != -1) {
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.setHover();
            this.openMenu = menu;
        }
    }

    private void showNextMenu() {
        Menu menu = this.findNextSibling();
        if (this.openMenu != null) {
            this.openMenu.hide();
        }
        this.openMenu = menu;
        if (!this.isMenuEmpty(menu)) {
            this.openMenu.show();
        }
    }

    private void showPrevMenu() {
        Menu menu = this.findPreviousSibling();
        if (this.openMenu != null) {
            this.openMenu.hide();
        }
        this.openMenu = menu;
        if (!this.isMenuEmpty(menu)) {
            this.openMenu.show();
        }
    }

    private Menu findPreviousSibling() {
        if (this.focusedMenuIndex == -1) {
            return null;
        }
        this.focusedMenuIndex = this.focusedMenuIndex == 0 ? this.container.getChildren().size() - 1 : --this.focusedMenuIndex;
        if (((Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex)).isDisable()) {
            return this.findPreviousSibling();
        }
        this.clearMenuButtonHover();
        return (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
    }

    private Menu findNextSibling() {
        if (this.focusedMenuIndex == -1) {
            return null;
        }
        this.focusedMenuIndex = this.focusedMenuIndex == this.container.getChildren().size() - 1 ? 0 : ++this.focusedMenuIndex;
        if (((Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex)).isDisable()) {
            return this.findNextSibling();
        }
        this.clearMenuButtonHover();
        return (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
    }

    private void updateFocusedIndex() {
        int n = 0;
        for (Node node : this.container.getChildren()) {
            if (node.isHover()) {
                this.focusedMenuIndex = n;
                return;
            }
            ++n;
        }
        this.focusedMenuIndex = -1;
    }

    private void clearMenuButtonHover() {
        for (Node node : this.container.getChildren()) {
            if (!node.isHover()) continue;
            ((MenuBarButton)node).clearHover();
            return;
        }
    }

    @Override
    public void onTraverse(Node node, Bounds bounds) {
        if (this.direction.equals((Object)Direction.NEXT)) {
            if (this.openMenu != null) {
                this.openMenu.hide();
            }
            this.focusedMenuIndex = 0;
            new TraversalEngine((Parent)((Object)this.getSkinnable()), false).trav((Node)((Object)this.getSkinnable()), Direction.NEXT);
        } else if (this.direction.equals((Object)Direction.DOWN)) {
            // empty if block
        }
    }

    @Override
    protected double snappedTopInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedTopInset();
    }

    @Override
    protected double snappedBottomInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedBottomInset();
    }

    @Override
    protected double snappedLeftInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedLeftInset();
    }

    @Override
    protected double snappedRightInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedRightInset();
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        this.container.resizeRelocate(d, d2, d3, d4);
    }

    @Override
    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        return this.container.minWidth(d) + this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        return this.container.prefWidth(d) + this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        return this.container.minHeight(d) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        return this.container.prefHeight(d) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        return ((MenuBar)this.getSkinnable()).prefHeight(-1.0);
    }

    static {
        wrappedDefaultMenus = new ArrayList<MenuBase>();
    }

    static class MenuBarButton
    extends MenuButton {
        private ChangeListener<Boolean> menuListener;
        private MenuBarSkin menuBarSkin;
        private Menu menu;

        public MenuBarButton(MenuBarSkin menuBarSkin, String string, Node node) {
            super(string, node);
            this.menuBarSkin = menuBarSkin;
        }

        public MenuBarSkin getMenuBarSkin() {
            return this.menuBarSkin;
        }

        private void clearHover() {
            this.setHover(false);
        }

        private void setHover() {
            this.setHover(true);
        }
    }
}

