/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TabPaneBehavior;
import com.sun.javafx.scene.control.skin.TitledPaneSkin;
import com.sun.javafx.scene.traversal.Direction;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;

public class TitledPaneBehavior
extends BehaviorBase<TitledPane> {
    private TitledPane titledPane;
    private static final String PRESS_ACTION = "Press";
    protected static final List<KeyBinding> TITLEDPANE_BINDINGS = new ArrayList<KeyBinding>();

    public TitledPaneBehavior(TitledPane titledPane) {
        super(titledPane, TITLEDPANE_BINDINGS);
        this.titledPane = titledPane;
    }

    @Override
    protected void callAction(String string) {
        switch (string) {
            case "Press": {
                if (!this.titledPane.isCollapsible() || !this.titledPane.isFocused()) break;
                this.titledPane.setExpanded(!this.titledPane.isExpanded());
                this.titledPane.requestFocus();
                break;
            }
            case "TraverseNext": 
            case "TraversePrevious": {
                TitledPaneSkin titledPaneSkin = (TitledPaneSkin)this.titledPane.getSkin();
                if (this.titledPane.isExpanded() && (!titledPaneSkin.getContentRegion().getImpl_traversalEngine().registeredNodes.isEmpty() || TabPaneBehavior.getFirstPopulatedInnerTraversalEngine(titledPaneSkin.getContentRegion().getChildren()) != null)) {
                    ObservableList<Node> observableList = this.titledPane.getChildrenUnmodifiable();
                    Node node = this.titledPane.getScene().getFocusOwner();
                    if (node != null && TitledPaneBehavior.isChildFocused(node, observableList)) {
                        node.impl_traverse("TraverseNext".equals(string) ? Direction.NEXT : Direction.PREVIOUS);
                        break;
                    }
                    if ("TraverseNext".equals(string)) {
                        TitledPaneBehavior.focusFirstChild(observableList);
                        break;
                    }
                    super.callAction(string);
                    break;
                }
                super.callAction(string);
                break;
            }
            default: {
                super.callAction(string);
            }
        }
    }

    public static boolean isChildFocused(Node node, List<Node> list) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == node) {
                bl = true;
                break;
            }
            if (!(list.get(i) instanceof Parent) || !TitledPaneBehavior.isChildFocused(node, ((Parent)list.get(i)).getChildrenUnmodifiable())) continue;
            return true;
        }
        return bl;
    }

    public static boolean focusFirstChild(List<Node> list) {
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            if (node.isFocusTraversable() && node.impl_isTreeVisible() && !node.isDisabled()) {
                node.requestFocus();
                return true;
            }
            if (!(node instanceof Parent) || !TitledPaneBehavior.focusFirstChild(((Parent)node).getChildrenUnmodifiable())) continue;
            return true;
        }
        return false;
    }

    public static boolean focusLastChild(List<Node> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            Node node = list.get(i);
            if (node.isFocusTraversable() && node.impl_isTreeVisible() && !node.isDisabled()) {
                node.requestFocus();
                return true;
            }
            if (!(node instanceof Parent) || !TitledPaneBehavior.focusFirstChild(((Parent)node).getChildrenUnmodifiable())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        TitledPane titledPane = (TitledPane)this.getControl();
        titledPane.requestFocus();
    }

    public void expand() {
        this.titledPane.setExpanded(true);
    }

    public void collapse() {
        this.titledPane.setExpanded(false);
    }

    public void toggle() {
        this.titledPane.setExpanded(!this.titledPane.isExpanded());
    }

    static {
        TITLEDPANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        TITLEDPANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        TITLEDPANE_BINDINGS.add(new KeyBinding(KeyCode.ENTER, PRESS_ACTION));
        TITLEDPANE_BINDINGS.add(new KeyBinding(KeyCode.SPACE, PRESS_ACTION));
    }
}

