/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TextInputControlBindings;
import com.sun.javafx.scene.control.skin.TextInputControlSkin;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import javafx.application.ConditionalFeature;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyEvent;

public abstract class TextInputControlBehavior<T extends TextInputControl>
extends BehaviorBase<T> {
    protected static final List<KeyBinding> TEXT_INPUT_BINDINGS = new ArrayList<KeyBinding>();
    T textInputControl;
    private KeyEvent lastEvent;
    private UndoManager undoManager = new UndoManager();
    private BreakIterator charIterator;
    private InvalidationListener textListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            if (!TextInputControlBehavior.this.isEditing()) {
                TextInputControlBehavior.this.undoManager.reset();
            }
            TextInputControlBehavior.this.invalidateBidi();
        }
    };
    private Bidi bidi = null;
    private Boolean mixed = null;
    private Boolean rtlText = null;
    private boolean editing = false;

    public TextInputControlBehavior(T t, List<KeyBinding> list) {
        super(t, list);
        this.textInputControl = t;
        ((TextInputControl)t).textProperty().addListener(this.textListener);
    }

    @Override
    public void dispose() {
        ((TextInputControl)this.textInputControl).textProperty().removeListener(this.textListener);
        super.dispose();
    }

    protected abstract void deleteChar(boolean var1);

    protected abstract void replaceText(int var1, int var2, String var3);

    protected abstract void setCaretAnimating(boolean var1);

    protected void scrollCharacterToVisible(int n) {
    }

    @Override
    protected void callActionForEvent(KeyEvent keyEvent) {
        this.lastEvent = keyEvent;
        super.callActionForEvent(keyEvent);
    }

    @Override
    public void callAction(String string) {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        boolean bl = false;
        this.setCaretAnimating(false);
        if (textInputControl.isEditable()) {
            this.setEditing(true);
            bl = true;
            if ("InputCharacter".equals(string)) {
                this.defaultKeyTyped(this.lastEvent);
            } else if ("Cut".equals(string)) {
                this.cut();
            } else if ("Paste".equals(string)) {
                this.paste();
            } else if ("DeletePreviousChar".equals(string)) {
                this.deletePreviousChar();
            } else if ("DeleteNextChar".equals(string)) {
                this.deleteNextChar();
            } else if ("DeletePreviousWord".equals(string)) {
                this.deletePreviousWord();
            } else if ("DeleteNextWord".equals(string)) {
                this.deleteNextWord();
            } else if ("DeleteSelection".equals(string)) {
                this.deleteSelection();
            } else if ("Undo".equals(string)) {
                this.undoManager.undo();
            } else if ("Redo".equals(string)) {
                this.undoManager.redo();
            } else {
                bl = false;
            }
            this.setEditing(false);
        }
        if (!bl) {
            bl = true;
            if ("Copy".equals(string)) {
                textInputControl.copy();
            } else if ("SelectBackward".equals(string)) {
                textInputControl.selectBackward();
            } else if ("SelectForward".equals(string)) {
                textInputControl.selectForward();
            } else if ("SelectLeft".equals(string)) {
                this.selectLeft();
            } else if ("SelectRight".equals(string)) {
                this.selectRight();
            } else if ("PreviousWord".equals(string)) {
                this.previousWord();
            } else if ("NextWord".equals(string)) {
                this.nextWord();
            } else if ("LeftWord".equals(string)) {
                this.leftWord();
            } else if ("RightWord".equals(string)) {
                this.rightWord();
            } else if ("SelectPreviousWord".equals(string)) {
                this.selectPreviousWord();
            } else if ("SelectNextWord".equals(string)) {
                this.selectNextWord();
            } else if ("SelectLeftWord".equals(string)) {
                this.selectLeftWord();
            } else if ("SelectRightWord".equals(string)) {
                this.selectRightWord();
            } else if ("SelectWord".equals(string)) {
                this.selectWord();
            } else if ("SelectAll".equals(string)) {
                textInputControl.selectAll();
            } else if ("Home".equals(string)) {
                textInputControl.home();
            } else if ("End".equals(string)) {
                textInputControl.end();
            } else if ("Forward".equals(string)) {
                textInputControl.forward();
            } else if ("Backward".equals(string)) {
                textInputControl.backward();
            } else if ("Right".equals(string)) {
                this.nextCharacterVisually(true);
            } else if ("Left".equals(string)) {
                this.nextCharacterVisually(false);
            } else if ("Fire".equals(string)) {
                this.fire(this.lastEvent);
            } else if ("Unselect".equals(string)) {
                textInputControl.deselect();
            } else if ("SelectHome".equals(string)) {
                this.selectHome();
            } else if ("SelectEnd".equals(string)) {
                this.selectEnd();
            } else if ("SelectHomeExtend".equals(string)) {
                this.selectHomeExtend();
            } else if ("SelectEndExtend".equals(string)) {
                this.selectEndExtend();
            } else if ("ToParent".equals(string)) {
                this.forwardToParent(this.lastEvent);
            } else if ("UseVK".equals(string) && PlatformImpl.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD)) {
                ((TextInputControlSkin)textInputControl.getSkin()).toggleUseVK();
            } else {
                bl = false;
            }
        }
        this.setCaretAnimating(true);
        if (!bl) {
            if ("TraverseNext".equals(string)) {
                this.traverseNext();
            } else if ("TraversePrevious".equals(string)) {
                this.traversePrevious();
            } else {
                super.callAction(string);
            }
        }
    }

    protected UndoManager getUndoManager() {
        return this.undoManager;
    }

    private void defaultKeyTyped(KeyEvent keyEvent) {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (!textInputControl.isEditable() || textInputControl.isDisabled()) {
            return;
        }
        String string = keyEvent.getCharacter();
        if (string.length() == 0) {
            return;
        }
        if ((keyEvent.isControlDown() || keyEvent.isAltDown() || PlatformUtil.isMac() && keyEvent.isMetaDown()) && (!keyEvent.isControlDown() && !PlatformUtil.isMac() || !keyEvent.isAltDown())) {
            return;
        }
        if (string.charAt(0) > '\u001f' && string.charAt(0) != '\u007f' && !keyEvent.isMetaDown()) {
            IndexRange indexRange = textInputControl.getSelection();
            int n = indexRange.getStart();
            int n2 = indexRange.getEnd();
            this.undoManager.addChange(n, textInputControl.textProperty().getValueSafe().substring(n, n2), string, true);
            this.replaceText(n, n2, string);
            this.scrollCharacterToVisible(n);
        }
    }

    private void invalidateBidi() {
        this.bidi = null;
        this.mixed = null;
        this.rtlText = null;
    }

    private Bidi getBidi() {
        if (this.bidi == null) {
            this.bidi = new Bidi(((TextInputControl)this.textInputControl).getText(), ((Node)this.textInputControl).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? 1 : 0);
        }
        return this.bidi;
    }

    protected boolean isMixed() {
        if (this.mixed == null) {
            this.mixed = this.getBidi().isMixed();
        }
        return this.mixed;
    }

    protected boolean isRTLText() {
        if (this.rtlText == null) {
            Bidi bidi = this.getBidi();
            this.rtlText = bidi.isRightToLeft() || this.isMixed() && ((Node)this.textInputControl).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
        }
        return this.rtlText;
    }

    private void nextCharacterVisually(boolean bl) {
        if (this.isMixed()) {
            TextInputControlSkin textInputControlSkin = (TextInputControlSkin)((Control)this.textInputControl).getSkin();
            textInputControlSkin.nextCharacterVisually(bl);
        } else if (bl != this.isRTLText()) {
            ((TextInputControl)this.textInputControl).forward();
        } else {
            ((TextInputControl)this.textInputControl).backward();
        }
    }

    private void selectLeft() {
        if (this.isRTLText()) {
            ((TextInputControl)this.textInputControl).selectForward();
        } else {
            ((TextInputControl)this.textInputControl).selectBackward();
        }
    }

    private void selectRight() {
        if (this.isRTLText()) {
            ((TextInputControl)this.textInputControl).selectBackward();
        } else {
            ((TextInputControl)this.textInputControl).selectForward();
        }
    }

    private void deletePreviousChar() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        IndexRange indexRange = textInputControl.getSelection();
        int n = indexRange.getStart();
        int n2 = indexRange.getEnd();
        if (n > 0 || n2 > n) {
            if (indexRange.getLength() == 0) {
                n2 = n;
                n = Character.offsetByCodePoints(textInputControl.getText(), n2, -1);
            }
            this.undoManager.addChange(n, textInputControl.getText().substring(n, n2), null);
        }
        this.deleteChar(true);
    }

    private void deleteNextChar() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        IndexRange indexRange = textInputControl.getSelection();
        int n = indexRange.getStart();
        int n2 = indexRange.getEnd();
        if (n < textInputControl.getLength() || n2 > n) {
            if (indexRange.getLength() == 0) {
                if (this.charIterator == null) {
                    this.charIterator = BreakIterator.getCharacterInstance();
                }
                this.charIterator.setText(textInputControl.getText());
                n2 = this.charIterator.following(n);
            }
            this.undoManager.addChange(n, textInputControl.getText().substring(n, n2), null);
        }
        this.deleteChar(false);
    }

    protected void deletePreviousWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        int n = textInputControl.getCaretPosition();
        if (n > 0) {
            textInputControl.previousWord();
            int n2 = textInputControl.getCaretPosition();
            this.undoManager.addChange(n2, textInputControl.getText().substring(n2, n), null);
            this.replaceText(n2, n, "");
        }
    }

    protected void deleteNextWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        int n = textInputControl.getCaretPosition();
        if (n < textInputControl.getLength()) {
            this.nextWord();
            int n2 = textInputControl.getCaretPosition();
            this.undoManager.addChange(n, textInputControl.getText().substring(n, n2), null);
            this.replaceText(n, n2, "");
        }
    }

    private void deleteSelection() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        IndexRange indexRange = textInputControl.getSelection();
        if (indexRange.getLength() > 0) {
            int n = indexRange.getStart();
            int n2 = indexRange.getEnd();
            this.undoManager.addChange(n, textInputControl.getText().substring(n, n2), null);
            this.deleteChar(false);
        }
    }

    private void cut() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        IndexRange indexRange = textInputControl.getSelection();
        if (indexRange.getLength() > 0) {
            int n = indexRange.getStart();
            int n2 = indexRange.getEnd();
            this.undoManager.addChange(n, textInputControl.getText().substring(n, n2), null);
        }
        textInputControl.cut();
    }

    private void paste() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        IndexRange indexRange = textInputControl.getSelection();
        int n = indexRange.getStart();
        int n2 = indexRange.getEnd();
        String string = textInputControl.textProperty().getValueSafe();
        String string2 = string.substring(n, n2);
        int n3 = string.length() - n2;
        textInputControl.paste();
        string = textInputControl.textProperty().getValueSafe();
        this.undoManager.addChange(n, string2, string.substring(n, string.length() - n3));
    }

    protected void selectPreviousWord() {
        ((TextInputControl)this.getControl()).selectPreviousWord();
    }

    protected void selectNextWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (PlatformUtil.isMac() || PlatformUtil.isLinux()) {
            textInputControl.selectEndOfNextWord();
        } else {
            textInputControl.selectNextWord();
        }
    }

    private void selectLeftWord() {
        if (this.isRTLText()) {
            this.selectNextWord();
        } else {
            this.selectPreviousWord();
        }
    }

    private void selectRightWord() {
        if (this.isRTLText()) {
            this.selectPreviousWord();
        } else {
            this.selectNextWord();
        }
    }

    protected void selectWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        textInputControl.previousWord();
        if (PlatformUtil.isWindows()) {
            textInputControl.selectNextWord();
        } else {
            textInputControl.selectEndOfNextWord();
        }
    }

    protected void previousWord() {
        ((TextInputControl)this.getControl()).previousWord();
    }

    protected void nextWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (PlatformUtil.isMac() || PlatformUtil.isLinux()) {
            textInputControl.endOfNextWord();
        } else {
            textInputControl.nextWord();
        }
    }

    private void leftWord() {
        if (this.isRTLText()) {
            this.nextWord();
        } else {
            this.previousWord();
        }
    }

    private void rightWord() {
        if (this.isRTLText()) {
            this.previousWord();
        } else {
            this.nextWord();
        }
    }

    protected void fire(KeyEvent keyEvent) {
    }

    protected void forwardToParent(KeyEvent keyEvent) {
        if (((TextInputControl)this.getControl()).getParent() != null) {
            ((TextInputControl)this.getControl()).getParent().fireEvent(keyEvent);
        }
    }

    private void selectHome() {
        ((TextInputControl)this.getControl()).selectHome();
    }

    private void selectEnd() {
        ((TextInputControl)this.getControl()).selectEnd();
    }

    private void selectHomeExtend() {
        ((TextInputControl)this.getControl()).extendSelection(0);
    }

    private void selectEndExtend() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        textInputControl.extendSelection(textInputControl.getLength());
    }

    protected void setEditing(boolean bl) {
        this.editing = bl;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    static {
        TEXT_INPUT_BINDINGS.addAll(TextInputControlBindings.BINDINGS);
        TEXT_INPUT_BINDINGS.add(new KeyBinding(null, KeyEvent.KEY_PRESSED, "Consume"));
    }

    static class Change {
        int start;
        String oldText;
        String newText;
        boolean appendable;

        Change(int n, String string, String string2) {
            this(n, string, string2, false);
        }

        Change(int n, String string, String string2, boolean bl) {
            this.start = n;
            this.oldText = string;
            this.newText = string2;
            this.appendable = bl;
        }
    }

    class UndoManager {
        private ArrayList<Change> chain = new ArrayList();
        private int currentIndex = 0;

        UndoManager() {
        }

        public void addChange(int n, String string, String string2) {
            this.addChange(n, string, string2, false);
        }

        public void addChange(int n, String string, String string2, boolean bl) {
            this.truncate();
            if (bl && this.currentIndex > 0 && (string == null || string.length() == 0)) {
                Change change = this.chain.get(this.currentIndex - 1);
                if (change.appendable && n == change.start + change.newText.length()) {
                    change.newText = change.newText + string2;
                    return;
                }
            }
            this.chain.add(new Change(n, string, string2, bl));
            ++this.currentIndex;
        }

        public void undo() {
            if (this.currentIndex > 0) {
                Change change = this.chain.get(this.currentIndex - 1);
                TextInputControlBehavior.this.replaceText(change.start, change.start + (change.newText != null ? change.newText.length() : 0), change.oldText != null ? change.oldText : "");
                --this.currentIndex;
                if (this.currentIndex > 0) {
                    this.chain.get((int)(this.currentIndex - 1)).appendable = false;
                }
            }
        }

        public void redo() {
            if (this.currentIndex < this.chain.size()) {
                Change change = this.chain.get(this.currentIndex);
                TextInputControlBehavior.this.replaceText(change.start, change.start + (change.oldText != null ? change.oldText.length() : 0), change.newText != null ? change.newText : "");
                change.appendable = false;
                ++this.currentIndex;
            }
        }

        public boolean canUndo() {
            return this.currentIndex > 0;
        }

        public boolean canRedo() {
            return this.currentIndex < this.chain.size();
        }

        public void reset() {
            this.chain.clear();
            this.currentIndex = 0;
        }

        private void truncate() {
            if (this.currentIndex > 0 && this.chain.size() > this.currentIndex) {
                this.chain.get((int)(this.currentIndex - 1)).appendable = false;
            }
            while (this.chain.size() > this.currentIndex) {
                this.chain.remove(this.chain.size() - 1);
            }
        }
    }
}

