/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.accessible;

import com.sun.javafx.accessible.providers.GridItemProvider;
import com.sun.javafx.accessible.providers.SelectionItemProvider;
import com.sun.javafx.scene.control.accessible.AccessibleControl;
import javafx.scene.Parent;
import javafx.scene.control.Cell;
import javafx.scene.control.ListView;

public final class AccessibleListItem
extends AccessibleControl
implements SelectionItemProvider,
GridItemProvider {
    Cell listCell;
    static ListView listView = null;

    public AccessibleListItem(Cell cell) {
        super(cell);
        this.listCell = cell;
        Parent parent = cell;
        if (listView == null) {
            while (parent.getParent() != null) {
                Parent parent2 = parent.getParent();
                if (parent2 instanceof ListView) {
                    listView = (ListView)parent2;
                    break;
                }
                parent = parent.getParent();
            }
        }
    }

    @Override
    public Object getPropertyValue(int n) {
        Object object = null;
        switch (n) {
            case 30005: 
            case 30105: {
                object = this.listCell.getText();
                break;
            }
            case 30003: {
                object = 50007;
                break;
            }
            case 30009: {
                object = this.listCell.isFocusTraversable();
                break;
            }
            case 30008: {
                object = this.listCell.isFocused();
                break;
            }
            case 30016: {
                object = true;
                break;
            }
            case 30010: {
                object = !this.listCell.isDisabled();
                break;
            }
            case 30012: {
                object = this.getClass().toString();
            }
        }
        return object;
    }

    @Override
    public void addToSelection() {
        listView.getSelectionModel().select(this.listCell);
    }

    @Override
    public void removeFromSelection() {
        listView.getSelectionModel().clearSelection();
    }

    @Override
    public void select() {
        listView.getSelectionModel().select(this.listCell);
    }

    @Override
    public boolean isSelected() {
        return this.listCell == listView.getSelectionModel().getSelectedItem();
    }

    @Override
    public Object getSelectionContainer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRow() {
        return listView.getItems().indexOf(this.listCell);
    }

    @Override
    public int getColumn() {
        return 1;
    }

    @Override
    public int getRowSpan() {
        return listView.getItems().size();
    }

    @Override
    public int getColumnSpan() {
        return 1;
    }

    @Override
    public Object getContainingGrid() {
        throw new UnsupportedOperationException();
    }
}

