/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.accessible;

import com.sun.javafx.Logging;
import com.sun.javafx.accessible.providers.ToggleProvider;
import com.sun.javafx.accessible.utils.ToggleState;
import com.sun.javafx.scene.control.accessible.AccessibleControl;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.CheckBox;
import sun.util.logging.PlatformLogger;

public class AccessibleCheckBox
extends AccessibleControl
implements ToggleProvider {
    CheckBox checkBox;

    public AccessibleCheckBox(CheckBox checkBox) {
        super(checkBox);
        this.checkBox = checkBox;
        checkBox.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                ToggleState toggleState = ToggleState.OFF;
                ToggleState toggleState2 = ToggleState.ON;
                CheckBox checkBox = (CheckBox)actionEvent.getSource();
                if (checkBox.isIndeterminate()) {
                    toggleState = ToggleState.INDETERMINATE;
                    toggleState2 = ToggleState.OFF;
                }
                if (checkBox.isSelected()) {
                    toggleState = ToggleState.ON;
                    toggleState2 = ToggleState.OFF;
                }
                AccessibleCheckBox.this.firePropertyChange(20004, toggleState2.hashCode(), toggleState.hashCode());
            }
        });
    }

    @Override
    public ToggleState getToggleState() {
        PlatformLogger platformLogger = Logging.getAccessibilityLogger();
        ToggleState toggleState = ToggleState.OFF;
        if (this.checkBox.isIndeterminate()) {
            toggleState = ToggleState.INDETERMINATE;
        }
        if (this.checkBox.isSelected()) {
            toggleState = ToggleState.ON;
        }
        if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
            platformLogger.finer(this.toString() + "getToggleState" + toggleState.toString());
        }
        return toggleState;
    }

    @Override
    public Object getPropertyValue(int n) {
        Object object = null;
        switch (n) {
            case 30005: 
            case 30105: {
                object = this.checkBox.getText();
                break;
            }
            case 30003: {
                object = 50002;
                break;
            }
            case 30009: {
                object = true;
                break;
            }
            case 30008: {
                object = this.checkBox.isFocused();
                break;
            }
            case 30016: {
                object = true;
                break;
            }
            case 30010: {
                object = !this.checkBox.isDisabled();
                break;
            }
            case 30012: {
                object = this.getClass().toString();
                break;
            }
            case 30086: {
                object = ToggleState.ON;
            }
        }
        return object;
    }

    @Override
    public Object getPatternProvider(int n) {
        return super.getAccessibleElement();
    }

    @Override
    public void toggle() {
        this.checkBox.arm();
    }
}

