/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.Namespace;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.Flags;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LexicalContextExpression;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.Source;

@Immutable
public final class FunctionNode
extends LexicalContextExpression
implements Flags<FunctionNode> {
    public static final Type FUNCTION_TYPE = Type.typeFor(ScriptFunction.class);
    private final Source source;
    @Ignore
    private final IdentNode ident;
    @Ignore
    private final FunctionNode snapshot;
    private final Block body;
    private final String name;
    private final CompileUnit compileUnit;
    private final Kind kind;
    private final List<IdentNode> parameters;
    private final long firstToken;
    private final long lastToken;
    @Ignore
    private final Set<Symbol> declaredSymbols;
    private final Namespace namespace;
    @Ignore
    private final EnumSet<CompilationState> compilationState;
    @Ignore
    private final Compiler.Hints hints;
    @Ignore
    private HashSet<String> thisProperties;
    private final int flags;
    private final int lineNumber;
    public static final int IS_ANONYMOUS = 1;
    public static final int IS_DECLARED = 2;
    public static final int IS_STRICT = 4;
    public static final int USES_ARGUMENTS = 8;
    public static final int IS_SPLIT = 16;
    public static final int HAS_EVAL = 32;
    public static final int HAS_NESTED_EVAL = 64;
    public static final int HAS_SCOPE_BLOCK = 128;
    public static final int DEFINES_ARGUMENTS = 256;
    public static final int USES_ANCESTOR_SCOPE = 512;
    public static final int IS_LAZY = 1024;
    public static final int HAS_LAZY_CHILDREN = 2048;
    public static final int IS_PROGRAM = 4096;
    public static final int HAS_FUNCTION_DECLARATIONS = 8192;
    public static final int CAN_SPECIALIZE = 16384;
    private static final int HAS_DEEP_EVAL = 96;
    private static final int HAS_ALL_VARS_IN_SCOPE = 2160;
    private static final int MAYBE_NEEDS_ARGUMENTS = 40;
    private static final int NEEDS_PARENT_SCOPE = 2656;
    private Type returnType = Type.UNKNOWN;

    public FunctionNode(Source source, int lineNumber, long token, int finish, long firstToken, Namespace namespace, IdentNode ident, String name, List<IdentNode> parameters, Kind kind, int flags) {
        super(token, finish);
        this.source = source;
        this.lineNumber = lineNumber;
        this.ident = ident;
        this.name = name;
        this.kind = kind;
        this.parameters = parameters;
        this.firstToken = firstToken;
        this.lastToken = token;
        this.namespace = namespace;
        this.compilationState = EnumSet.of(CompilationState.INITIALIZED);
        this.declaredSymbols = new HashSet<Symbol>();
        this.flags = flags;
        this.compileUnit = null;
        this.body = null;
        this.snapshot = null;
        this.hints = null;
    }

    private FunctionNode(FunctionNode functionNode, long lastToken, int flags, String name, Type returnType, CompileUnit compileUnit, EnumSet<CompilationState> compilationState, Block body, List<IdentNode> parameters, FunctionNode snapshot, Compiler.Hints hints) {
        super(functionNode);
        this.lineNumber = functionNode.lineNumber;
        this.flags = flags;
        this.name = name;
        this.returnType = returnType;
        this.compileUnit = compileUnit;
        this.lastToken = lastToken;
        this.compilationState = compilationState;
        this.body = body;
        this.parameters = parameters;
        this.snapshot = snapshot;
        this.hints = hints;
        this.source = functionNode.source;
        this.ident = functionNode.ident;
        this.namespace = functionNode.namespace;
        this.declaredSymbols = functionNode.declaredSymbols;
        this.kind = functionNode.kind;
        this.firstToken = functionNode.firstToken;
        this.thisProperties = functionNode.thisProperties;
    }

    @Override
    public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterFunctionNode(this)) {
            return visitor.leaveFunctionNode(this.setBody(lc, (Block)this.body.accept(visitor)));
        }
        return this;
    }

    public Source getSource() {
        return this.source;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public FunctionNode getSnapshot() {
        return this.snapshot;
    }

    public FunctionNode clearSnapshot(LexicalContext lc) {
        if (this.snapshot == null) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, this.lastToken, this.flags, this.name, this.returnType, this.compileUnit, this.compilationState, this.body, this.parameters, null, this.hints));
    }

    public FunctionNode snapshot(LexicalContext lc) {
        if (this.snapshot == this) {
            return this;
        }
        if (this.isProgram() || this.parameters.isEmpty()) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, this.lastToken, this.flags, this.name, this.returnType, this.compileUnit, this.compilationState, this.body, this.parameters, this, this.hints));
    }

    public boolean canSpecialize() {
        return this.snapshot != null && this.getFlag(16384);
    }

    public EnumSet<CompilationState> getState() {
        return this.compilationState;
    }

    public boolean hasState(EnumSet<CompilationState> state) {
        return this.compilationState.equals(state);
    }

    public boolean hasState(CompilationState state) {
        return this.compilationState.contains((Object)state);
    }

    public FunctionNode setState(LexicalContext lc, CompilationState state) {
        if (this.compilationState.contains((Object)state)) {
            return this;
        }
        EnumSet<CompilationState> newState = EnumSet.copyOf(this.compilationState);
        newState.add(state);
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, this.lastToken, this.flags, this.name, this.returnType, this.compileUnit, newState, this.body, this.parameters, this.snapshot, this.hints));
    }

    public Compiler.Hints getHints() {
        return this.hints == null ? Compiler.Hints.EMPTY : this.hints;
    }

    public FunctionNode setHints(LexicalContext lc, Compiler.Hints hints) {
        if (this.hints == hints) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, this.lastToken, this.flags, this.name, this.returnType, this.compileUnit, this.compilationState, this.body, this.parameters, this.snapshot, hints));
    }

    public String uniqueName(String base) {
        return this.namespace.uniqueName(base);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append('[');
        sb.append(this.returnType);
        sb.append(']');
        sb.append(' ');
        sb.append("function");
        if (this.ident != null) {
            sb.append(' ');
            this.ident.toString(sb);
        }
        sb.append('(');
        boolean first = true;
        for (IdentNode parameter : this.parameters) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            parameter.toString(sb);
        }
        sb.append(')');
    }

    @Override
    public boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    public FunctionNode setFlags(LexicalContext lc, int flags) {
        if (this.flags == flags) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, this.lastToken, flags, this.name, this.returnType, this.compileUnit, this.compilationState, this.body, this.parameters, this.snapshot, this.hints));
    }

    @Override
    public FunctionNode clearFlag(LexicalContext lc, int flag) {
        return this.setFlags(lc, this.flags & ~flag);
    }

    @Override
    public FunctionNode setFlag(LexicalContext lc, int flag) {
        return this.setFlags(lc, this.flags | flag);
    }

    public boolean isProgram() {
        return this.getFlag(4096);
    }

    public boolean isLazy() {
        return this.getFlag(1024);
    }

    public boolean hasEval() {
        return this.getFlag(32);
    }

    public long getFirstToken() {
        return this.firstToken;
    }

    public boolean hasDeclaredFunctions() {
        return this.getFlag(8192);
    }

    public boolean needsCallee() {
        return this.needsParentScope() || this.needsSelfSymbol() || this.isSplit() || this.needsArguments() && !this.isStrict();
    }

    public IdentNode getIdent() {
        return this.ident;
    }

    public Set<Symbol> getDeclaredSymbols() {
        return Collections.unmodifiableSet(this.declaredSymbols);
    }

    public void addDeclaredSymbol(Symbol symbol) {
        this.declaredSymbols.add(symbol);
    }

    public Block getBody() {
        return this.body;
    }

    public FunctionNode setBody(LexicalContext lc, Block body) {
        if (this.body == body) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, this.lastToken, this.flags | (body.needsScope() ? 128 : 0), this.name, this.returnType, this.compileUnit, this.compilationState, body, this.parameters, this.snapshot, this.hints));
    }

    public boolean isVarArg() {
        return this.needsArguments() || this.parameters.size() > 250;
    }

    public boolean needsArguments() {
        return this.getFlag(40) && !this.getFlag(256) && !this.isProgram();
    }

    public boolean needsParentScope() {
        return this.getFlag(2656) || this.isProgram();
    }

    public void addThisProperty(String key) {
        if (this.thisProperties == null) {
            this.thisProperties = new HashSet();
        }
        this.thisProperties.add(key);
    }

    public int countThisProperties() {
        return this.thisProperties == null ? 0 : this.thisProperties.size();
    }

    public boolean hasScopeBlock() {
        return this.getFlag(128);
    }

    public Kind getKind() {
        return this.kind;
    }

    public long getLastToken() {
        return this.lastToken;
    }

    public FunctionNode setLastToken(LexicalContext lc, long lastToken) {
        if (this.lastToken == lastToken) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, lastToken, this.flags, this.name, this.returnType, this.compileUnit, this.compilationState, this.body, this.parameters, this.snapshot, this.hints));
    }

    public String getName() {
        return this.name;
    }

    public FunctionNode setName(LexicalContext lc, String name) {
        if (this.name.equals(name)) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, this.lastToken, this.flags, name, this.returnType, this.compileUnit, this.compilationState, this.body, this.parameters, this.snapshot, this.hints));
    }

    public boolean allVarsInScope() {
        return this.isProgram() || this.getFlag(2160);
    }

    public boolean isSplit() {
        return this.getFlag(16);
    }

    public boolean hasLazyChildren() {
        return this.getFlag(2048);
    }

    public List<IdentNode> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public FunctionNode setParameters(LexicalContext lc, List<IdentNode> parameters) {
        if (this.parameters == parameters) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, this.lastToken, this.flags, this.name, this.returnType, this.compileUnit, this.compilationState, this.body, parameters, this.snapshot, this.hints));
    }

    public boolean isDeclared() {
        return this.getFlag(2);
    }

    public boolean isAnonymous() {
        return this.getFlag(1);
    }

    public boolean needsSelfSymbol() {
        return this.body.getFlag(2);
    }

    @Override
    public Type getType() {
        return FUNCTION_TYPE;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public FunctionNode setReturnType(LexicalContext lc, Type returnType) {
        if (this.returnType == returnType) {
            return this;
        }
        Type type = Type.widest(this.returnType, returnType.isObject() ? Type.OBJECT : returnType);
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, this.lastToken, this.flags, this.name, type, this.compileUnit, this.compilationState, this.body.setReturnType(type), this.parameters, this.snapshot, this.hints));
    }

    public boolean isStrict() {
        return this.getFlag(4);
    }

    public CompileUnit getCompileUnit() {
        return this.compileUnit;
    }

    public FunctionNode setCompileUnit(LexicalContext lc, CompileUnit compileUnit) {
        if (this.compileUnit == compileUnit) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new FunctionNode(this, this.lastToken, this.flags, this.name, this.returnType, compileUnit, this.compilationState, this.body, this.parameters, this.snapshot, this.hints));
    }

    public Symbol compilerConstant(CompilerConstants cc) {
        return this.body.getExistingSymbol(cc.symbolName());
    }

    public static enum CompilationState {
        INITIALIZED,
        PARSED,
        PARSE_ERROR,
        CONSTANT_FOLDED,
        LOWERED,
        ATTR,
        SPLIT,
        FINALIZED,
        EMITTED;

    }

    public static enum Kind {
        NORMAL,
        SCRIPT,
        GETTER,
        SETTER;

    }
}

