/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.TopLevelWindowListener;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.Exported;
import sun.awt.AppContext;

@Exported
public class AWTEventMonitor {
    private static boolean runningOnJDK1_4 = false;
    @Deprecated
    protected static Component componentWithFocus = null;
    @Deprecated
    protected static ComponentListener componentListener = null;
    @Deprecated
    protected static ContainerListener containerListener = null;
    @Deprecated
    protected static FocusListener focusListener = null;
    @Deprecated
    protected static KeyListener keyListener = null;
    @Deprecated
    protected static MouseListener mouseListener = null;
    @Deprecated
    protected static MouseMotionListener mouseMotionListener = null;
    @Deprecated
    protected static WindowListener windowListener = null;
    @Deprecated
    protected static ActionListener actionListener = null;
    @Deprecated
    protected static AdjustmentListener adjustmentListener = null;
    @Deprecated
    protected static ItemListener itemListener = null;
    @Deprecated
    protected static TextListener textListener = null;
    @Deprecated
    protected static AWTEventsListener awtListener = new AWTEventsListener();
    private static final Object componentWithFocusKey;
    private static final Object componentListenerKey;
    private static final Object containerListenerKey;
    private static final Object focusListenerKey;
    private static final Object keyListenerKey;
    private static final Object mouseListenerKey;
    private static final Object mouseMotionListenerKey;
    private static final Object windowListenerKey;
    private static final Object actionListenerKey;
    private static final Object adjustmentListenerKey;
    private static final Object itemListenerKey;
    private static final Object textListenerKey;
    private static final Object awtListenerKey;

    private static void setComponentWithFocus(Component component) {
        if (component == null) {
            AppContext.getAppContext().remove(componentWithFocusKey);
        } else {
            AppContext.getAppContext().put(componentWithFocusKey, component);
        }
    }

    public static Component getComponentWithFocus() {
        return (Component)AppContext.getAppContext().get(componentWithFocusKey);
    }

    private static void setComponentListener(ComponentListener componentListener) {
        if (componentListener == null) {
            AppContext.getAppContext().remove(componentListenerKey);
        } else {
            AppContext.getAppContext().put(componentListenerKey, componentListener);
        }
    }

    private static ComponentListener getComponentListener() {
        return (ComponentListener)AppContext.getAppContext().get(componentListenerKey);
    }

    private static void setContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            AppContext.getAppContext().remove(containerListenerKey);
        } else {
            AppContext.getAppContext().put(containerListenerKey, containerListener);
        }
    }

    private static ContainerListener getContainerListener() {
        return (ContainerListener)AppContext.getAppContext().get(containerListenerKey);
    }

    private static void setFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            AppContext.getAppContext().remove(focusListenerKey);
        } else {
            AppContext.getAppContext().put(focusListenerKey, focusListener);
        }
    }

    private static FocusListener getFocusListener() {
        return (FocusListener)AppContext.getAppContext().get(focusListenerKey);
    }

    private static void setKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            AppContext.getAppContext().remove(keyListenerKey);
        } else {
            AppContext.getAppContext().put(keyListenerKey, keyListener);
        }
    }

    private static KeyListener getKeyListener() {
        return (KeyListener)AppContext.getAppContext().get(keyListenerKey);
    }

    private static void setMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            AppContext.getAppContext().remove(mouseListenerKey);
        } else {
            AppContext.getAppContext().put(mouseListenerKey, mouseListener);
        }
    }

    private static MouseListener getMouseListener() {
        return (MouseListener)AppContext.getAppContext().get(mouseListenerKey);
    }

    private static void setMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            AppContext.getAppContext().remove(mouseMotionListenerKey);
        } else {
            AppContext.getAppContext().put(mouseMotionListenerKey, mouseMotionListener);
        }
    }

    private static MouseMotionListener getMouseMotionListener() {
        return (MouseMotionListener)AppContext.getAppContext().get(mouseMotionListenerKey);
    }

    private static void setWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            AppContext.getAppContext().remove(windowListenerKey);
        } else {
            AppContext.getAppContext().put(windowListenerKey, windowListener);
        }
    }

    private static WindowListener getWindowListener() {
        return (WindowListener)AppContext.getAppContext().get(windowListenerKey);
    }

    private static void setActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            AppContext.getAppContext().remove(actionListenerKey);
        } else {
            AppContext.getAppContext().put(actionListenerKey, actionListener);
        }
    }

    private static ActionListener getActionListener() {
        return (ActionListener)AppContext.getAppContext().get(actionListenerKey);
    }

    private static void setAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            AppContext.getAppContext().remove(adjustmentListenerKey);
        } else {
            AppContext.getAppContext().put(adjustmentListenerKey, adjustmentListener);
        }
    }

    private static AdjustmentListener getAdjustmentListener() {
        return (AdjustmentListener)AppContext.getAppContext().get(adjustmentListenerKey);
    }

    private static void setItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            AppContext.getAppContext().remove(itemListenerKey);
        } else {
            AppContext.getAppContext().put(itemListenerKey, itemListener);
        }
    }

    private static ItemListener getItemListener() {
        return (ItemListener)AppContext.getAppContext().get(itemListenerKey);
    }

    private static void setTextListener(TextListener textListener) {
        if (textListener == null) {
            AppContext.getAppContext().remove(textListenerKey);
        } else {
            AppContext.getAppContext().put(textListenerKey, textListener);
        }
    }

    private static TextListener getTextListener() {
        return (TextListener)AppContext.getAppContext().get(textListenerKey);
    }

    private static void setAWTListener(AWTEventsListener aWTEventsListener) {
        if (aWTEventsListener == null) {
            AppContext.getAppContext().remove(awtListenerKey);
        } else {
            AppContext.getAppContext().put(awtListenerKey, aWTEventsListener);
        }
    }

    private static AWTEventsListener getAWTListener() {
        return (AWTEventsListener)AppContext.getAppContext().get(awtListenerKey);
    }

    public static void addComponentListener(ComponentListener componentListener) {
        ComponentListener componentListener2 = AWTEventMonitor.getComponentListener();
        if (componentListener2 == null) {
            AWTEventMonitor.getAWTListener().installListeners(2);
        }
        AWTEventMonitor.setComponentListener(AWTEventMulticaster.add(componentListener2, componentListener));
    }

    public static void removeComponentListener(ComponentListener componentListener) {
        AWTEventMonitor.setComponentListener(AWTEventMulticaster.remove(AWTEventMonitor.getComponentListener(), componentListener));
        if (AWTEventMonitor.getComponentListener() == null) {
            AWTEventMonitor.getAWTListener().removeListeners(2);
        }
    }

    public static void addContainerListener(ContainerListener containerListener) {
        AWTEventMonitor.setContainerListener(AWTEventMulticaster.add(AWTEventMonitor.getContainerListener(), containerListener));
    }

    public static void removeContainerListener(ContainerListener containerListener) {
        AWTEventMonitor.setContainerListener(AWTEventMulticaster.remove(AWTEventMonitor.getContainerListener(), containerListener));
    }

    public static void addFocusListener(FocusListener focusListener) {
        AWTEventMonitor.setFocusListener(AWTEventMulticaster.add(AWTEventMonitor.getFocusListener(), focusListener));
    }

    public static void removeFocusListener(FocusListener focusListener) {
        AWTEventMonitor.setFocusListener(AWTEventMulticaster.remove(AWTEventMonitor.getFocusListener(), focusListener));
    }

    public static void addKeyListener(KeyListener keyListener) {
        KeyListener keyListener2 = AWTEventMonitor.getKeyListener();
        if (keyListener2 == null) {
            AWTEventMonitor.getAWTListener().installListeners(6);
        }
        AWTEventMonitor.setKeyListener(AWTEventMulticaster.add(keyListener2, keyListener));
    }

    public static void removeKeyListener(KeyListener keyListener) {
        AWTEventMonitor.setKeyListener(AWTEventMulticaster.remove(AWTEventMonitor.getKeyListener(), keyListener));
        if (AWTEventMonitor.getKeyListener() == null) {
            AWTEventMonitor.getAWTListener().removeListeners(6);
        }
    }

    public static void addMouseListener(MouseListener mouseListener) {
        MouseListener mouseListener2 = AWTEventMonitor.getMouseListener();
        if (mouseListener2 == null) {
            AWTEventMonitor.getAWTListener().installListeners(7);
        }
        AWTEventMonitor.setMouseListener(AWTEventMulticaster.add(mouseListener2, mouseListener));
    }

    public static void removeMouseListener(MouseListener mouseListener) {
        AWTEventMonitor.setMouseListener(AWTEventMulticaster.remove(AWTEventMonitor.getMouseListener(), mouseListener));
        if (AWTEventMonitor.getMouseListener() == null) {
            AWTEventMonitor.getAWTListener().removeListeners(7);
        }
    }

    public static void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        MouseMotionListener mouseMotionListener2 = AWTEventMonitor.getMouseMotionListener();
        if (mouseMotionListener2 == null) {
            AWTEventMonitor.getAWTListener().installListeners(8);
        }
        AWTEventMonitor.setMouseMotionListener(AWTEventMulticaster.add(mouseMotionListener2, mouseMotionListener));
    }

    public static void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        AWTEventMonitor.setMouseMotionListener(AWTEventMulticaster.remove(AWTEventMonitor.getMouseMotionListener(), mouseMotionListener));
        if (AWTEventMonitor.getMouseMotionListener() == null) {
            AWTEventMonitor.getAWTListener().removeListeners(8);
        }
    }

    public static void addWindowListener(WindowListener windowListener) {
        WindowListener windowListener2 = AWTEventMonitor.getWindowListener();
        if (windowListener2 == null) {
            AWTEventMonitor.getAWTListener().installListeners(11);
        }
        AWTEventMonitor.setWindowListener(AWTEventMulticaster.add(windowListener2, windowListener));
    }

    public static void removeWindowListener(WindowListener windowListener) {
        AWTEventMonitor.setWindowListener(AWTEventMulticaster.remove(AWTEventMonitor.getWindowListener(), windowListener));
        if (AWTEventMonitor.getWindowListener() == null) {
            AWTEventMonitor.getAWTListener().removeListeners(11);
        }
    }

    public static void addActionListener(ActionListener actionListener) {
        ActionListener actionListener2 = AWTEventMonitor.getActionListener();
        if (actionListener2 == null) {
            AWTEventMonitor.getAWTListener().installListeners(0);
        }
        AWTEventMonitor.setActionListener(AWTEventMulticaster.add(actionListener2, actionListener));
    }

    public static void removeActionListener(ActionListener actionListener) {
        AWTEventMonitor.setActionListener(AWTEventMulticaster.remove(AWTEventMonitor.getActionListener(), actionListener));
        if (AWTEventMonitor.getActionListener() == null) {
            AWTEventMonitor.getAWTListener().removeListeners(0);
        }
    }

    public static void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        AdjustmentListener adjustmentListener2 = AWTEventMonitor.getAdjustmentListener();
        if (adjustmentListener2 == null) {
            AWTEventMonitor.getAWTListener().installListeners(1);
        }
        AWTEventMonitor.setAdjustmentListener(AWTEventMulticaster.add(adjustmentListener2, adjustmentListener));
    }

    public static void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        AWTEventMonitor.setAdjustmentListener(AWTEventMulticaster.remove(AWTEventMonitor.getAdjustmentListener(), adjustmentListener));
        if (AWTEventMonitor.getAdjustmentListener() == null) {
            AWTEventMonitor.getAWTListener().removeListeners(1);
        }
    }

    public static void addItemListener(ItemListener itemListener) {
        ItemListener itemListener2 = AWTEventMonitor.getItemListener();
        if (itemListener2 == null) {
            AWTEventMonitor.getAWTListener().installListeners(5);
        }
        AWTEventMonitor.setItemListener(AWTEventMulticaster.add(itemListener2, itemListener));
    }

    public static void removeItemListener(ItemListener itemListener) {
        AWTEventMonitor.setItemListener(AWTEventMulticaster.remove(AWTEventMonitor.getItemListener(), itemListener));
        if (AWTEventMonitor.getItemListener() == null) {
            AWTEventMonitor.getAWTListener().removeListeners(5);
        }
    }

    public static void addTextListener(TextListener textListener) {
        TextListener textListener2 = AWTEventMonitor.getTextListener();
        if (textListener2 == null) {
            AWTEventMonitor.getAWTListener().installListeners(10);
        }
        AWTEventMonitor.setTextListener(AWTEventMulticaster.add(textListener2, textListener));
    }

    public static void removeTextListener(TextListener textListener) {
        AWTEventMonitor.setTextListener(AWTEventMulticaster.remove(AWTEventMonitor.getTextListener(), textListener));
        if (AWTEventMonitor.getTextListener() == null) {
            AWTEventMonitor.getAWTListener().removeListeners(10);
        }
    }

    static {
        AWTEventMonitor.setAWTListener(new AWTEventsListener());
        componentWithFocusKey = new Object();
        componentListenerKey = new Object();
        containerListenerKey = new Object();
        focusListenerKey = new Object();
        keyListenerKey = new Object();
        mouseListenerKey = new Object();
        mouseMotionListenerKey = new Object();
        windowListenerKey = new Object();
        actionListenerKey = new Object();
        adjustmentListenerKey = new Object();
        itemListenerKey = new Object();
        textListenerKey = new Object();
        awtListenerKey = new Object();
    }

    static class AWTEventsListener
    implements TopLevelWindowListener,
    ActionListener,
    AdjustmentListener,
    ComponentListener,
    ContainerListener,
    FocusListener,
    ItemListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    TextListener,
    WindowListener,
    ChangeListener {
        private Class[] actionListeners;
        private Method removeActionMethod;
        private Method addActionMethod;
        private Object[] actionArgs;
        private Class[] itemListeners;
        private Method removeItemMethod;
        private Method addItemMethod;
        private Object[] itemArgs;
        private Class[] textListeners;
        private Method removeTextMethod;
        private Method addTextMethod;
        private Object[] textArgs;
        private Class[] windowListeners;
        private Method removeWindowMethod;
        private Method addWindowMethod;
        private Object[] windowArgs;

        public AWTEventsListener() {
            String string = System.getProperty("java.version");
            if (string != null) {
                runningOnJDK1_4 = string.compareTo("1.4") >= 0;
            }
            this.initializeIntrospection();
            this.installListeners();
            if (runningOnJDK1_4) {
                MenuSelectionManager.defaultManager().addChangeListener(this);
            }
            EventQueueMonitor.addTopLevelWindowListener(this);
        }

        private boolean initializeIntrospection() {
            try {
                this.actionListeners = new Class[1];
                this.actionArgs = new Object[1];
                this.actionListeners[0] = Class.forName("java.awt.event.ActionListener");
                this.actionArgs[0] = this;
                this.itemListeners = new Class[1];
                this.itemArgs = new Object[1];
                this.itemListeners[0] = Class.forName("java.awt.event.ItemListener");
                this.itemArgs[0] = this;
                this.textListeners = new Class[1];
                this.textArgs = new Object[1];
                this.textListeners[0] = Class.forName("java.awt.event.TextListener");
                this.textArgs[0] = this;
                this.windowListeners = new Class[1];
                this.windowArgs = new Object[1];
                this.windowListeners[0] = Class.forName("java.awt.event.WindowListener");
                this.windowArgs[0] = this;
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("EXCEPTION - Class 'java.awt.event.*' not in CLASSPATH");
                return false;
            }
        }

        protected void installListeners() {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    this.installListeners(windowArray[i]);
                }
            }
        }

        protected void installListeners(int n) {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    this.installListeners(windowArray[i], n);
                }
            }
        }

        protected void installListeners(Component component) {
            this.installListeners(component, 3);
            this.installListeners(component, 4);
            if (AWTEventMonitor.getComponentListener() != null) {
                this.installListeners(component, 2);
            }
            if (AWTEventMonitor.getKeyListener() != null) {
                this.installListeners(component, 6);
            }
            if (AWTEventMonitor.getMouseListener() != null) {
                this.installListeners(component, 7);
            }
            if (AWTEventMonitor.getMouseMotionListener() != null) {
                this.installListeners(component, 8);
            }
            if (AWTEventMonitor.getWindowListener() != null) {
                this.installListeners(component, 11);
            }
            if (AWTEventMonitor.getActionListener() != null) {
                this.installListeners(component, 0);
            }
            if (AWTEventMonitor.getAdjustmentListener() != null) {
                this.installListeners(component, 1);
            }
            if (AWTEventMonitor.getItemListener() != null) {
                this.installListeners(component, 5);
            }
            if (AWTEventMonitor.getTextListener() != null) {
                this.installListeners(component, 10);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.processFocusGained();
        }

        private void processFocusGained() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null) {
                return;
            }
            MenuSelectionManager.defaultManager().removeChangeListener(this);
            MenuSelectionManager.defaultManager().addChangeListener(this);
            if (component instanceof JRootPane) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 1) {
                    Component component2 = menuElementArray[menuElementArray.length - 2].getComponent();
                    Component component3 = menuElementArray[menuElementArray.length - 1].getComponent();
                    if (component3 instanceof JPopupMenu || component3 instanceof JMenu) {
                        AWTEventMonitor.setComponentWithFocus(component3);
                    } else if (component2 instanceof JPopupMenu) {
                        AWTEventMonitor.setComponentWithFocus(component2);
                    }
                }
            } else {
                AWTEventMonitor.setComponentWithFocus(component);
            }
        }

        protected void installListeners(Component component, int n) {
            switch (n) {
                case 0: {
                    try {
                        this.removeActionMethod = component.getClass().getMethod("removeActionListener", this.actionListeners);
                        this.addActionMethod = component.getClass().getMethod("addActionListener", this.actionListeners);
                        try {
                            this.removeActionMethod.invoke((Object)component, this.actionArgs);
                            this.addActionMethod.invoke((Object)component, this.actionArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 1: {
                    if (!(component instanceof Adjustable)) break;
                    ((Adjustable)((Object)component)).removeAdjustmentListener(this);
                    ((Adjustable)((Object)component)).addAdjustmentListener(this);
                    break;
                }
                case 2: {
                    component.removeComponentListener(this);
                    component.addComponentListener(this);
                    break;
                }
                case 3: {
                    if (!(component instanceof Container)) break;
                    ((Container)component).removeContainerListener(this);
                    ((Container)component).addContainerListener(this);
                    break;
                }
                case 4: {
                    component.removeFocusListener(this);
                    component.addFocusListener(this);
                    if (runningOnJDK1_4) {
                        this.processFocusGained();
                        break;
                    }
                    if (component == AWTEventMonitor.getComponentWithFocus() || !component.hasFocus()) break;
                    AWTEventMonitor.setComponentWithFocus(component);
                    break;
                }
                case 5: {
                    try {
                        this.removeItemMethod = component.getClass().getMethod("removeItemListener", this.itemListeners);
                        this.addItemMethod = component.getClass().getMethod("addItemListener", this.itemListeners);
                        try {
                            this.removeItemMethod.invoke((Object)component, this.itemArgs);
                            this.addItemMethod.invoke((Object)component, this.itemArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 6: {
                    component.removeKeyListener(this);
                    component.addKeyListener(this);
                    break;
                }
                case 7: {
                    component.removeMouseListener(this);
                    component.addMouseListener(this);
                    break;
                }
                case 8: {
                    component.removeMouseMotionListener(this);
                    component.addMouseMotionListener(this);
                    break;
                }
                case 10: {
                    try {
                        this.removeTextMethod = component.getClass().getMethod("removeTextListener", this.textListeners);
                        this.addTextMethod = component.getClass().getMethod("addTextListener", this.textListeners);
                        try {
                            this.removeTextMethod.invoke((Object)component, this.textArgs);
                            this.addTextMethod.invoke((Object)component, this.textArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 11: {
                    try {
                        this.removeWindowMethod = component.getClass().getMethod("removeWindowListener", this.windowListeners);
                        this.addWindowMethod = component.getClass().getMethod("addWindowListener", this.windowListeners);
                        try {
                            this.removeWindowMethod.invoke((Object)component, this.windowArgs);
                            this.addWindowMethod.invoke((Object)component, this.windowArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (component instanceof Container) {
                int n2 = ((Container)component).getComponentCount();
                for (int i = 0; i < n2; ++i) {
                    this.installListeners(((Container)component).getComponent(i), n);
                }
            }
        }

        protected void removeListeners(int n) {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    this.removeListeners(windowArray[i], n);
                }
            }
        }

        protected void removeListeners(Component component) {
            if (AWTEventMonitor.getComponentListener() != null) {
                this.removeListeners(component, 2);
            }
            if (AWTEventMonitor.getKeyListener() != null) {
                this.removeListeners(component, 6);
            }
            if (AWTEventMonitor.getMouseListener() != null) {
                this.removeListeners(component, 7);
            }
            if (AWTEventMonitor.getMouseMotionListener() != null) {
                this.removeListeners(component, 8);
            }
            if (AWTEventMonitor.getWindowListener() != null) {
                this.removeListeners(component, 11);
            }
            if (AWTEventMonitor.getActionListener() != null) {
                this.removeListeners(component, 0);
            }
            if (AWTEventMonitor.getAdjustmentListener() != null) {
                this.removeListeners(component, 1);
            }
            if (AWTEventMonitor.getItemListener() != null) {
                this.removeListeners(component, 5);
            }
            if (AWTEventMonitor.getTextListener() != null) {
                this.removeListeners(component, 10);
            }
        }

        protected void removeListeners(Component component, int n) {
            switch (n) {
                case 0: {
                    try {
                        this.removeActionMethod = component.getClass().getMethod("removeActionListener", this.actionListeners);
                        try {
                            this.removeActionMethod.invoke((Object)component, this.actionArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 1: {
                    if (!(component instanceof Adjustable)) break;
                    ((Adjustable)((Object)component)).removeAdjustmentListener(this);
                    break;
                }
                case 2: {
                    component.removeComponentListener(this);
                    break;
                }
                case 5: {
                    try {
                        this.removeItemMethod = component.getClass().getMethod("removeItemListener", this.itemListeners);
                        try {
                            this.removeItemMethod.invoke((Object)component, this.itemArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 6: {
                    component.removeKeyListener(this);
                    break;
                }
                case 7: {
                    component.removeMouseListener(this);
                    break;
                }
                case 8: {
                    component.removeMouseMotionListener(this);
                    break;
                }
                case 10: {
                    try {
                        this.removeTextMethod = component.getClass().getMethod("removeTextListener", this.textListeners);
                        try {
                            this.removeTextMethod.invoke((Object)component, this.textArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 11: {
                    try {
                        this.removeWindowMethod = component.getClass().getMethod("removeWindowListener", this.windowListeners);
                        try {
                            this.removeWindowMethod.invoke((Object)component, this.windowArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (component instanceof Container) {
                int n2 = ((Container)component).getComponentCount();
                for (int i = 0; i < n2; ++i) {
                    this.removeListeners(((Container)component).getComponent(i), n);
                }
            }
        }

        @Override
        public void topLevelWindowCreated(Window window) {
            this.installListeners(window);
        }

        @Override
        public void topLevelWindowDestroyed(Window window) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionListener actionListener = AWTEventMonitor.getActionListener();
            if (actionListener != null) {
                actionListener.actionPerformed(actionEvent);
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            AdjustmentListener adjustmentListener = AWTEventMonitor.getAdjustmentListener();
            if (adjustmentListener != null) {
                adjustmentListener.adjustmentValueChanged(adjustmentEvent);
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            ComponentListener componentListener = AWTEventMonitor.getComponentListener();
            if (componentListener != null) {
                componentListener.componentHidden(componentEvent);
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            ComponentListener componentListener = AWTEventMonitor.getComponentListener();
            if (componentListener != null) {
                componentListener.componentMoved(componentEvent);
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ComponentListener componentListener = AWTEventMonitor.getComponentListener();
            if (componentListener != null) {
                componentListener.componentResized(componentEvent);
            }
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            ComponentListener componentListener = AWTEventMonitor.getComponentListener();
            if (componentListener != null) {
                componentListener.componentShown(componentEvent);
            }
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            this.installListeners(containerEvent.getChild());
            ContainerListener containerListener = AWTEventMonitor.getContainerListener();
            if (containerListener != null) {
                containerListener.componentAdded(containerEvent);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            this.removeListeners(containerEvent.getChild());
            ContainerListener containerListener = AWTEventMonitor.getContainerListener();
            if (containerListener != null) {
                containerListener.componentRemoved(containerEvent);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            AWTEventMonitor.setComponentWithFocus((Component)focusEvent.getSource());
            FocusListener focusListener = AWTEventMonitor.getFocusListener();
            if (focusListener != null) {
                focusListener.focusGained(focusEvent);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AWTEventMonitor.setComponentWithFocus(null);
            FocusListener focusListener = AWTEventMonitor.getFocusListener();
            if (focusListener != null) {
                focusListener.focusLost(focusEvent);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemListener itemListener = AWTEventMonitor.getItemListener();
            if (itemListener != null) {
                itemListener.itemStateChanged(itemEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            KeyListener keyListener = AWTEventMonitor.getKeyListener();
            if (keyListener != null) {
                keyListener.keyPressed(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            KeyListener keyListener = AWTEventMonitor.getKeyListener();
            if (keyListener != null) {
                keyListener.keyReleased(keyEvent);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            KeyListener keyListener = AWTEventMonitor.getKeyListener();
            if (keyListener != null) {
                keyListener.keyTyped(keyEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MouseListener mouseListener = AWTEventMonitor.getMouseListener();
            if (mouseListener != null) {
                mouseListener.mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MouseListener mouseListener = AWTEventMonitor.getMouseListener();
            if (mouseListener != null) {
                mouseListener.mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MouseListener mouseListener = AWTEventMonitor.getMouseListener();
            if (mouseListener != null) {
                mouseListener.mouseExited(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MouseListener mouseListener = AWTEventMonitor.getMouseListener();
            if (mouseListener != null) {
                mouseListener.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MouseListener mouseListener = AWTEventMonitor.getMouseListener();
            if (mouseListener != null) {
                mouseListener.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MouseMotionListener mouseMotionListener = AWTEventMonitor.getMouseMotionListener();
            if (mouseMotionListener != null) {
                mouseMotionListener.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MouseMotionListener mouseMotionListener = AWTEventMonitor.getMouseMotionListener();
            if (mouseMotionListener != null) {
                mouseMotionListener.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            TextListener textListener = AWTEventMonitor.getTextListener();
            if (textListener != null) {
                textListener.textValueChanged(textEvent);
            }
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            WindowListener windowListener = AWTEventMonitor.getWindowListener();
            if (windowListener != null) {
                windowListener.windowOpened(windowEvent);
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            WindowListener windowListener = AWTEventMonitor.getWindowListener();
            if (windowListener != null) {
                windowListener.windowClosing(windowEvent);
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            WindowListener windowListener = AWTEventMonitor.getWindowListener();
            if (windowListener != null) {
                windowListener.windowClosed(windowEvent);
            }
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            WindowListener windowListener = AWTEventMonitor.getWindowListener();
            if (windowListener != null) {
                windowListener.windowIconified(windowEvent);
            }
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            WindowListener windowListener = AWTEventMonitor.getWindowListener();
            if (windowListener != null) {
                windowListener.windowDeiconified(windowEvent);
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            WindowListener windowListener = AWTEventMonitor.getWindowListener();
            if (windowListener != null) {
                windowListener.windowActivated(windowEvent);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            WindowListener windowListener = AWTEventMonitor.getWindowListener();
            if (windowListener != null) {
                windowListener.windowDeactivated(windowEvent);
            }
        }
    }
}

