/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import sun.security.action.GetBooleanAction;
import sun.security.provider.certpath.PKIX;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.GeneralSubtrees;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public abstract class Builder {
    private static final Debug debug = Debug.getInstance("certpath");
    private Set<String> matchingPolicies;
    final PKIX.BuilderParams buildParams;
    final X509CertSelector targetCertConstraints;
    static final boolean USE_AIA = AccessController.doPrivileged(new GetBooleanAction("com.sun.security.enableAIAcaIssuers"));

    Builder(PKIX.BuilderParams builderParams) {
        this.buildParams = builderParams;
        this.targetCertConstraints = (X509CertSelector)builderParams.targetCertConstraints();
    }

    abstract Collection<X509Certificate> getMatchingCerts(State var1, List<CertStore> var2) throws CertStoreException, CertificateException, IOException;

    abstract void verifyCert(X509Certificate var1, State var2, List<X509Certificate> var3) throws GeneralSecurityException;

    abstract boolean isPathCompleted(X509Certificate var1);

    abstract void addCertToPath(X509Certificate var1, LinkedList<X509Certificate> var2);

    abstract void removeFinalCertFromPath(LinkedList<X509Certificate> var1);

    static int distance(GeneralNameInterface generalNameInterface, GeneralNameInterface generalNameInterface2, int n) {
        switch (generalNameInterface.constrains(generalNameInterface2)) {
            case -1: {
                if (debug != null) {
                    debug.println("Builder.distance(): Names are different types");
                }
                return n;
            }
            case 3: {
                if (debug != null) {
                    debug.println("Builder.distance(): Names are same type but in different subtrees");
                }
                return n;
            }
            case 0: {
                return 0;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                return n;
            }
        }
        return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
    }

    static int hops(GeneralNameInterface generalNameInterface, GeneralNameInterface generalNameInterface2, int n) {
        int n2 = generalNameInterface.constrains(generalNameInterface2);
        switch (n2) {
            case -1: {
                if (debug != null) {
                    debug.println("Builder.hops(): Names are different types");
                }
                return n;
            }
            case 3: {
                break;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
            }
            case 1: {
                return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
            }
            default: {
                return n;
            }
        }
        if (generalNameInterface.getType() != 4) {
            if (debug != null) {
                debug.println("Builder.hops(): hopDistance not implemented for this name type");
            }
            return n;
        }
        X500Name x500Name = (X500Name)generalNameInterface;
        X500Name x500Name2 = (X500Name)generalNameInterface2;
        X500Name x500Name3 = x500Name.commonAncestor(x500Name2);
        if (x500Name3 == null) {
            if (debug != null) {
                debug.println("Builder.hops(): Names are in different namespaces");
            }
            return n;
        }
        int n3 = x500Name3.subtreeDepth();
        int n4 = x500Name.subtreeDepth();
        int n5 = x500Name2.subtreeDepth();
        return n4 + n5 - 2 * n3;
    }

    static int targetDistance(NameConstraintsExtension nameConstraintsExtension, X509Certificate x509Certificate, GeneralNameInterface generalNameInterface) throws IOException {
        Object object;
        X509CertImpl x509CertImpl;
        if (nameConstraintsExtension != null && !nameConstraintsExtension.verify(x509Certificate)) {
            throw new IOException("certificate does not satisfy existing name constraints");
        }
        try {
            x509CertImpl = X509CertImpl.toImpl(x509Certificate);
        }
        catch (CertificateException certificateException) {
            throw new IOException("Invalid certificate", certificateException);
        }
        X500Name x500Name = X500Name.asX500Name(x509CertImpl.getSubjectX500Principal());
        if (x500Name.equals(generalNameInterface)) {
            return 0;
        }
        SubjectAlternativeNameExtension subjectAlternativeNameExtension = x509CertImpl.getSubjectAlternativeNameExtension();
        if (subjectAlternativeNameExtension != null && (object = subjectAlternativeNameExtension.get("subject_name")) != null) {
            int n = ((GeneralNames)object).size();
            for (int i = 0; i < n; ++i) {
                GeneralNameInterface generalNameInterface2 = ((GeneralNames)object).get(i).getName();
                if (!generalNameInterface2.equals(generalNameInterface)) continue;
                return 0;
            }
        }
        if ((object = x509CertImpl.getNameConstraintsExtension()) == null) {
            return -1;
        }
        if (nameConstraintsExtension != null) {
            nameConstraintsExtension.merge((NameConstraintsExtension)object);
        } else {
            nameConstraintsExtension = (NameConstraintsExtension)((NameConstraintsExtension)object).clone();
        }
        if (debug != null) {
            debug.println("Builder.targetDistance() merged constraints: " + String.valueOf(nameConstraintsExtension));
        }
        GeneralSubtrees generalSubtrees = nameConstraintsExtension.get("permitted_subtrees");
        GeneralSubtrees generalSubtrees2 = nameConstraintsExtension.get("excluded_subtrees");
        if (generalSubtrees != null) {
            generalSubtrees.reduce(generalSubtrees2);
        }
        if (debug != null) {
            debug.println("Builder.targetDistance() reduced constraints: " + generalSubtrees);
        }
        if (!nameConstraintsExtension.verify(generalNameInterface)) {
            throw new IOException("New certificate not allowed to sign certificate for target");
        }
        if (generalSubtrees == null) {
            return -1;
        }
        int n = generalSubtrees.size();
        for (int i = 0; i < n; ++i) {
            GeneralNameInterface generalNameInterface3 = generalSubtrees.get(i).getName().getName();
            int n2 = Builder.distance(generalNameInterface3, generalNameInterface, -1);
            if (n2 < 0) continue;
            return n2 + 1;
        }
        return -1;
    }

    Set<String> getMatchingPolicies() {
        if (this.matchingPolicies != null) {
            Set<String> set = this.buildParams.initialPolicies();
            if (!set.isEmpty() && !set.contains("2.5.29.32.0") && this.buildParams.policyMappingInhibited()) {
                this.matchingPolicies = new HashSet<String>(set);
                this.matchingPolicies.add("2.5.29.32.0");
            } else {
                this.matchingPolicies = Collections.emptySet();
            }
        }
        return this.matchingPolicies;
    }

    boolean addMatchingCerts(X509CertSelector x509CertSelector, Collection<CertStore> collection, Collection<X509Certificate> collection2, boolean bl) {
        X509Certificate x509Certificate = x509CertSelector.getCertificate();
        if (x509Certificate != null) {
            if (x509CertSelector.match(x509Certificate) && !X509CertImpl.isSelfSigned(x509Certificate, this.buildParams.sigProvider())) {
                if (debug != null) {
                    debug.println("Builder.addMatchingCerts: adding target cert");
                }
                return collection2.add(x509Certificate);
            }
            return false;
        }
        boolean bl2 = false;
        for (CertStore certStore : collection) {
            try {
                Collection<? extends Certificate> collection3 = certStore.getCertificates(x509CertSelector);
                for (Certificate certificate : collection3) {
                    if (X509CertImpl.isSelfSigned((X509Certificate)certificate, this.buildParams.sigProvider()) || !collection2.add((X509Certificate)certificate)) continue;
                    bl2 = true;
                }
                if (bl || !bl2) continue;
                return true;
            }
            catch (CertStoreException certStoreException) {
                if (debug == null) continue;
                debug.println("Builder.addMatchingCerts, non-fatal exception retrieving certs: " + certStoreException);
                certStoreException.printStackTrace();
            }
        }
        return bl2;
    }
}

