/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.misc.Cleaner;
import sun.misc.JavaNioAccess;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.FileLockTable;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThreadSet;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.Util;
import sun.security.action.GetPropertyAction;

public class FileChannelImpl
extends FileChannel {
    private static final long allocationGranularity;
    private final FileDispatcher nd;
    private final FileDescriptor fd;
    private final boolean writable;
    private final boolean readable;
    private final boolean append;
    private final Object parent;
    private final NativeThreadSet threads = new NativeThreadSet(2);
    private final Object positionLock = new Object();
    private static volatile boolean transferSupported;
    private static volatile boolean pipeSupported;
    private static volatile boolean fileSupported;
    private static final long MAPPED_TRANSFER_SIZE = 0x800000L;
    private static final int TRANSFER_SIZE = 8192;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private volatile FileLockTable fileLockTable;
    private static boolean isSharedFileLockTable;
    private static volatile boolean propertyChecked;

    private FileChannelImpl(FileDescriptor fileDescriptor, boolean bl, boolean bl2, boolean bl3, Object object) {
        this.fd = fileDescriptor;
        this.readable = bl;
        this.writable = bl2;
        this.append = bl3;
        this.parent = object;
        this.nd = new FileDispatcherImpl(bl3);
    }

    public static FileChannel open(FileDescriptor fileDescriptor, boolean bl, boolean bl2, Object object) {
        return new FileChannelImpl(fileDescriptor, bl, bl2, false, object);
    }

    public static FileChannel open(FileDescriptor fileDescriptor, boolean bl, boolean bl2, boolean bl3, Object object) {
        return new FileChannelImpl(fileDescriptor, bl, bl2, bl3, object);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() throws IOException {
        if (this.fileLockTable != null) {
            Iterator<FileLock> iterator = this.fileLockTable.removeAll().iterator();
            while (iterator.hasNext()) {
                FileLock fileLock;
                FileLock fileLock2 = fileLock = iterator.next();
                synchronized (fileLock2) {
                    if (fileLock.isValid()) {
                        this.nd.release(this.fd, fileLock.position(), fileLock.size());
                        ((FileLockImpl)fileLock).invalidate();
                    }
                }
            }
        }
        this.nd.preClose(this.fd);
        this.threads.signalAndWait();
        if (this.parent != null) {
            ((Closeable)this.parent).close();
        } else {
            this.nd.close(this.fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            int n4;
            int n;
            int n2;
            block10: {
                n2 = 0;
                n = -1;
                this.begin();
                n = this.threads.add();
                if (this.isOpen()) break block10;
                int n3 = 0;
                this.threads.remove(n);
                this.end(n2 > 0);
                assert (IOStatus.check(n2));
                return n3;
            }
            try {
                while ((n2 = IOUtil.read(this.fd, byteBuffer, -1L, this.nd)) == -3 && this.isOpen()) {
                }
                n4 = IOStatus.normalize(n2);
                this.threads.remove(n);
                this.end(n2 > 0);
            }
            catch (Throwable throwable) {
                this.threads.remove(n);
                this.end(n2 > 0);
                assert (IOStatus.check(n2));
                throw throwable;
            }
            assert (IOStatus.check(n2));
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            long l3;
            int n3;
            long l;
            block11: {
                l = 0L;
                n3 = -1;
                this.begin();
                n3 = this.threads.add();
                if (this.isOpen()) break block11;
                long l2 = 0L;
                this.threads.remove(n3);
                this.end(l > 0L);
                assert (IOStatus.check(l));
                return l2;
            }
            try {
                while ((l = IOUtil.read(this.fd, byteBufferArray, n, n2, this.nd)) == -3L && this.isOpen()) {
                }
                l3 = IOStatus.normalize(l);
                this.threads.remove(n3);
                this.end(l > 0L);
            }
            catch (Throwable throwable) {
                this.threads.remove(n3);
                this.end(l > 0L);
                assert (IOStatus.check(l));
                throw throwable;
            }
            assert (IOStatus.check(l));
            return l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            int n4;
            int n;
            int n2;
            block10: {
                n2 = 0;
                n = -1;
                this.begin();
                n = this.threads.add();
                if (this.isOpen()) break block10;
                int n3 = 0;
                this.threads.remove(n);
                this.end(n2 > 0);
                assert (IOStatus.check(n2));
                return n3;
            }
            try {
                while ((n2 = IOUtil.write(this.fd, byteBuffer, -1L, this.nd)) == -3 && this.isOpen()) {
                }
                n4 = IOStatus.normalize(n2);
                this.threads.remove(n);
                this.end(n2 > 0);
            }
            catch (Throwable throwable) {
                this.threads.remove(n);
                this.end(n2 > 0);
                assert (IOStatus.check(n2));
                throw throwable;
            }
            assert (IOStatus.check(n2));
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            long l3;
            int n3;
            long l;
            block11: {
                l = 0L;
                n3 = -1;
                this.begin();
                n3 = this.threads.add();
                if (this.isOpen()) break block11;
                long l2 = 0L;
                this.threads.remove(n3);
                this.end(l > 0L);
                assert (IOStatus.check(l));
                return l2;
            }
            try {
                while ((l = IOUtil.write(this.fd, byteBufferArray, n, n2, this.nd)) == -3L && this.isOpen()) {
                }
                l3 = IOStatus.normalize(l);
                this.threads.remove(n3);
                this.end(l > 0L);
            }
            catch (Throwable throwable) {
                this.threads.remove(n3);
                this.end(l > 0L);
                assert (IOStatus.check(l));
                throw throwable;
            }
            assert (IOStatus.check(l));
            return l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long position() throws IOException {
        this.ensureOpen();
        Object object = this.positionLock;
        synchronized (object) {
            long l4;
            int n;
            long l;
            block9: {
                l = -1L;
                n = -1;
                this.begin();
                n = this.threads.add();
                if (this.isOpen()) break block9;
                long l2 = 0L;
                this.threads.remove(n);
                this.end(l > -1L);
                assert (IOStatus.check(l));
                return l2;
            }
            try {
                do {
                    long l2 = l = this.append ? this.nd.size(this.fd) : this.position0(this.fd, -1L);
                } while (l == -3L && this.isOpen());
                l4 = IOStatus.normalize(l);
                this.threads.remove(n);
                this.end(l > -1L);
            }
            catch (Throwable throwable) {
                this.threads.remove(n);
                this.end(l > -1L);
                assert (IOStatus.check(l));
                throw throwable;
            }
            assert (IOStatus.check(l));
            return l4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileChannel position(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            FileChannelImpl fileChannelImpl;
            int n;
            long l2;
            block10: {
                l2 = -1L;
                n = -1;
                this.begin();
                n = this.threads.add();
                if (this.isOpen()) break block10;
                FileChannel fileChannel = null;
                this.threads.remove(n);
                this.end(l2 > -1L);
                assert (IOStatus.check(l2));
                return fileChannel;
            }
            try {
                while ((l2 = this.position0(this.fd, l)) == -3L && this.isOpen()) {
                }
                fileChannelImpl = this;
                this.threads.remove(n);
                this.end(l2 > -1L);
            }
            catch (Throwable throwable) {
                this.threads.remove(n);
                this.end(l2 > -1L);
                assert (IOStatus.check(l2));
                throw throwable;
            }
            assert (IOStatus.check(l2));
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long size() throws IOException {
        this.ensureOpen();
        Object object = this.positionLock;
        synchronized (object) {
            long l3;
            int n;
            long l;
            block9: {
                l = -1L;
                n = -1;
                this.begin();
                n = this.threads.add();
                if (this.isOpen()) break block9;
                long l2 = -1L;
                this.threads.remove(n);
                this.end(l > -1L);
                assert (IOStatus.check(l));
                return l2;
            }
            try {
                while ((l = this.nd.size(this.fd)) == -3L && this.isOpen()) {
                }
                l3 = IOStatus.normalize(l);
                this.threads.remove(n);
                this.end(l > -1L);
            }
            catch (Throwable throwable) {
                this.threads.remove(n);
                this.end(l > -1L);
                assert (IOStatus.check(l));
                throw throwable;
            }
            assert (IOStatus.check(l));
            return l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileChannel truncate(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            FileChannelImpl fileChannelImpl;
            int n;
            long l2;
            int n2;
            block25: {
                long l3;
                block24: {
                    block23: {
                        block22: {
                            n2 = -1;
                            l2 = -1L;
                            n = -1;
                            this.begin();
                            n = this.threads.add();
                            if (this.isOpen()) break block22;
                            FileChannel fileChannel = null;
                            this.threads.remove(n);
                            this.end(n2 > -1);
                            assert (IOStatus.check(n2));
                            return fileChannel;
                        }
                        while ((l3 = this.nd.size(this.fd)) == -3L && this.isOpen()) {
                        }
                        if (this.isOpen()) break block23;
                        FileChannel fileChannel = null;
                        this.threads.remove(n);
                        this.end(n2 > -1);
                        assert (IOStatus.check(n2));
                        return fileChannel;
                    }
                    while ((l2 = this.position0(this.fd, -1L)) == -3L && this.isOpen()) {
                    }
                    if (this.isOpen()) break block24;
                    FileChannel fileChannel = null;
                    this.threads.remove(n);
                    this.end(n2 > -1);
                    assert (IOStatus.check(n2));
                    return fileChannel;
                }
                assert (l2 >= 0L);
                if (l >= l3) break block25;
                while ((n2 = this.nd.truncate(this.fd, l)) == -3 && this.isOpen()) {
                }
                if (this.isOpen()) break block25;
                FileChannel fileChannel = null;
                this.threads.remove(n);
                this.end(n2 > -1);
                assert (IOStatus.check(n2));
                return fileChannel;
            }
            try {
                if (l2 > l) {
                    l2 = l;
                }
                while ((n2 = (int)this.position0(this.fd, l2)) == -3 && this.isOpen()) {
                }
                fileChannelImpl = this;
                this.threads.remove(n);
                this.end(n2 > -1);
            }
            catch (Throwable throwable) {
                this.threads.remove(n);
                this.end(n2 > -1);
                assert (IOStatus.check(n2));
                throw throwable;
            }
            assert (IOStatus.check(n2));
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(boolean bl) throws IOException {
        int n;
        int n2;
        block7: {
            this.ensureOpen();
            n2 = -1;
            n = -1;
            this.begin();
            n = this.threads.add();
            if (this.isOpen()) break block7;
            this.threads.remove(n);
            this.end(n2 > -1);
            assert (IOStatus.check(n2));
            return;
        }
        try {
            while ((n2 = this.nd.force(this.fd, bl)) == -3 && this.isOpen()) {
            }
            this.threads.remove(n);
            this.end(n2 > -1);
        }
        catch (Throwable throwable) {
            this.threads.remove(n);
            this.end(n2 > -1);
            assert (IOStatus.check(n2));
            throw throwable;
        }
        assert (IOStatus.check(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToDirectly(long l, int n, WritableByteChannel writableByteChannel) throws IOException {
        int n2;
        long l2;
        block18: {
            block17: {
                long l3;
                int n3;
                int n4;
                block16: {
                    if (!transferSupported) {
                        return -4L;
                    }
                    FileDescriptor fileDescriptor = null;
                    if (writableByteChannel instanceof FileChannelImpl) {
                        if (!fileSupported) {
                            return -6L;
                        }
                        fileDescriptor = ((FileChannelImpl)writableByteChannel).fd;
                    } else if (writableByteChannel instanceof SelChImpl) {
                        if (writableByteChannel instanceof SinkChannelImpl && !pipeSupported) {
                            return -6L;
                        }
                        fileDescriptor = ((SelChImpl)((Object)writableByteChannel)).getFD();
                    }
                    if (fileDescriptor == null) {
                        return -4L;
                    }
                    n4 = IOUtil.fdVal(this.fd);
                    if (n4 == (n3 = IOUtil.fdVal(fileDescriptor))) {
                        return -4L;
                    }
                    l2 = -1L;
                    n2 = -1;
                    this.begin();
                    n2 = this.threads.add();
                    if (this.isOpen()) break block16;
                    long l4 = -1L;
                    this.threads.remove(n2);
                    this.end(l2 > -1L);
                    return l4;
                }
                try {
                    while ((l2 = this.transferTo0(n4, l, n, n3)) == -3L && this.isOpen()) {
                    }
                    if (l2 != -6L) break block17;
                    if (writableByteChannel instanceof SinkChannelImpl) {
                        pipeSupported = false;
                    }
                    if (writableByteChannel instanceof FileChannelImpl) {
                        fileSupported = false;
                    }
                    l3 = -6L;
                    this.threads.remove(n2);
                    this.end(l2 > -1L);
                }
                catch (Throwable throwable) {
                    this.threads.remove(n2);
                    this.end(l2 > -1L);
                    throw throwable;
                }
                return l3;
            }
            if (l2 != -4L) break block18;
            transferSupported = false;
            long l5 = -4L;
            this.threads.remove(n2);
            this.end(l2 > -1L);
            return l5;
        }
        long l6 = IOStatus.normalize(l2);
        this.threads.remove(n2);
        this.end(l2 > -1L);
        return l6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToTrustedChannel(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        boolean bl = writableByteChannel instanceof SelChImpl;
        if (!(writableByteChannel instanceof FileChannelImpl) && !bl) {
            return -4L;
        }
        long l3 = l2;
        while (l3 > 0L) {
            long l4 = Math.min(l3, 0x800000L);
            try {
                MappedByteBuffer mappedByteBuffer = this.map(FileChannel.MapMode.READ_ONLY, l, l4);
                try {
                    int n = writableByteChannel.write(mappedByteBuffer);
                    assert (n >= 0);
                    l3 -= (long)n;
                    if (bl) break;
                    assert (n > 0);
                    l += (long)n;
                }
                finally {
                    FileChannelImpl.unmap(mappedByteBuffer);
                }
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                assert (!writableByteChannel.isOpen());
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    closedByInterruptException.addSuppressed(throwable);
                }
                throw closedByInterruptException;
            }
            catch (IOException iOException) {
                if (l3 != l2) break;
                throw iOException;
            }
        }
        return l2 - l3;
    }

    private long transferToArbitraryChannel(long l, int n, WritableByteChannel writableByteChannel) throws IOException {
        int n2 = Math.min(n, 8192);
        ByteBuffer byteBuffer = Util.getTemporaryDirectBuffer(n2);
        long l2 = 0L;
        long l3 = l;
        try {
            Util.erase(byteBuffer);
            while (l2 < (long)n) {
                byteBuffer.limit(Math.min((int)((long)n - l2), 8192));
                int n3 = this.read(byteBuffer, l3);
                if (n3 <= 0) break;
                byteBuffer.flip();
                int n4 = writableByteChannel.write(byteBuffer);
                l2 += (long)n4;
                if (n4 != n3) break;
                l3 += (long)n4;
                byteBuffer.clear();
            }
            long l4 = l2;
            return l4;
        }
        catch (IOException iOException) {
            if (l2 > 0L) {
                long l5 = l2;
                return l5;
            }
            throw iOException;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer);
        }
    }

    @Override
    public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        long l3;
        this.ensureOpen();
        if (!writableByteChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        if (writableByteChannel instanceof FileChannelImpl && !((FileChannelImpl)writableByteChannel).writable) {
            throw new NonWritableChannelException();
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        long l4 = this.size();
        if (l > l4) {
            return 0L;
        }
        int n = (int)Math.min(l2, Integer.MAX_VALUE);
        if (l4 - l < (long)n) {
            n = (int)(l4 - l);
        }
        if ((l3 = this.transferToDirectly(l, n, writableByteChannel)) >= 0L) {
            return l3;
        }
        l3 = this.transferToTrustedChannel(l, n, writableByteChannel);
        if (l3 >= 0L) {
            return l3;
        }
        return this.transferToArbitraryChannel(l, n, writableByteChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferFromFileChannel(FileChannelImpl fileChannelImpl, long l, long l2) throws IOException {
        if (!fileChannelImpl.readable) {
            throw new NonReadableChannelException();
        }
        Object object = fileChannelImpl.positionLock;
        synchronized (object) {
            long l3;
            long l4;
            long l5 = fileChannelImpl.position();
            long l6 = l4 = Math.min(l2, fileChannelImpl.size() - l5);
            long l7 = l5;
            while (l6 > 0L) {
                l3 = Math.min(l6, 0x800000L);
                MappedByteBuffer mappedByteBuffer = fileChannelImpl.map(FileChannel.MapMode.READ_ONLY, l7, l3);
                try {
                    long l8 = this.write(mappedByteBuffer, l);
                    assert (l8 > 0L);
                    l7 += l8;
                    l += l8;
                    l6 -= l8;
                }
                catch (IOException iOException) {
                    if (l6 != l4) break;
                    throw iOException;
                }
                finally {
                    FileChannelImpl.unmap(mappedByteBuffer);
                }
            }
            l3 = l4 - l6;
            fileChannelImpl.position(l5 + l3);
            return l3;
        }
    }

    private long transferFromArbitraryChannel(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        int n = (int)Math.min(l2, 8192L);
        ByteBuffer byteBuffer = Util.getTemporaryDirectBuffer(n);
        long l3 = 0L;
        long l4 = l;
        try {
            Util.erase(byteBuffer);
            while (l3 < l2) {
                byteBuffer.limit((int)Math.min(l2 - l3, 8192L));
                int n2 = readableByteChannel.read(byteBuffer);
                if (n2 <= 0) break;
                byteBuffer.flip();
                int n3 = this.write(byteBuffer, l4);
                l3 += (long)n3;
                if (n3 != n2) break;
                l4 += (long)n3;
                byteBuffer.clear();
            }
            long l5 = l3;
            return l5;
        }
        catch (IOException iOException) {
            if (l3 > 0L) {
                long l6 = l3;
                return l6;
            }
            throw iOException;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer);
        }
    }

    @Override
    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        this.ensureOpen();
        if (!readableByteChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (l > this.size()) {
            return 0L;
        }
        if (readableByteChannel instanceof FileChannelImpl) {
            return this.transferFromFileChannel((FileChannelImpl)readableByteChannel, l, l2);
        }
        return this.transferFromArbitraryChannel(readableByteChannel, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        this.ensureOpen();
        if (this.nd.needsPositionLock()) {
            Object object = this.positionLock;
            synchronized (object) {
                return this.readInternal(byteBuffer, l);
            }
        }
        return this.readInternal(byteBuffer, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readInternal(ByteBuffer byteBuffer, long l) throws IOException {
        int n;
        int n2;
        int n3;
        block8: {
            assert (!this.nd.needsPositionLock() || Thread.holdsLock(this.positionLock));
            n3 = 0;
            n2 = -1;
            this.begin();
            n2 = this.threads.add();
            if (this.isOpen()) break block8;
            int n4 = -1;
            this.threads.remove(n2);
            this.end(n3 > 0);
            assert (IOStatus.check(n3));
            return n4;
        }
        try {
            while ((n3 = IOUtil.read(this.fd, byteBuffer, l, this.nd)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n3);
            this.threads.remove(n2);
            this.end(n3 > 0);
        }
        catch (Throwable throwable) {
            this.threads.remove(n2);
            this.end(n3 > 0);
            assert (IOStatus.check(n3));
            throw throwable;
        }
        assert (IOStatus.check(n3));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        this.ensureOpen();
        if (this.nd.needsPositionLock()) {
            Object object = this.positionLock;
            synchronized (object) {
                return this.writeInternal(byteBuffer, l);
            }
        }
        return this.writeInternal(byteBuffer, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeInternal(ByteBuffer byteBuffer, long l) throws IOException {
        int n;
        int n2;
        int n3;
        block8: {
            assert (!this.nd.needsPositionLock() || Thread.holdsLock(this.positionLock));
            n3 = 0;
            n2 = -1;
            this.begin();
            n2 = this.threads.add();
            if (this.isOpen()) break block8;
            int n4 = -1;
            this.threads.remove(n2);
            this.end(n3 > 0);
            assert (IOStatus.check(n3));
            return n4;
        }
        try {
            while ((n3 = IOUtil.write(this.fd, byteBuffer, l, this.nd)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n3);
            this.threads.remove(n2);
            this.end(n3 > 0);
        }
        catch (Throwable throwable) {
            this.threads.remove(n2);
            this.end(n3 > 0);
            assert (IOStatus.check(n3));
            throw throwable;
        }
        assert (IOStatus.check(n3));
        return n;
    }

    private static void unmap(MappedByteBuffer mappedByteBuffer) {
        Cleaner cleaner = ((DirectBuffer)((Object)mappedByteBuffer)).cleaner();
        if (cleaner != null) {
            cleaner.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        this.ensureOpen();
        if (mapMode == null) {
            throw new NullPointerException("Mode is null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (l + l2 < 0L) {
            throw new IllegalArgumentException("Position + size overflow");
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size exceeds Integer.MAX_VALUE");
        }
        int n = -1;
        if (mapMode == FileChannel.MapMode.READ_ONLY) {
            n = 0;
        } else if (mapMode == FileChannel.MapMode.READ_WRITE) {
            n = 1;
        } else if (mapMode == FileChannel.MapMode.PRIVATE) {
            n = 2;
        }
        assert (n >= 0);
        if (mapMode != FileChannel.MapMode.READ_ONLY && !this.writable) {
            throw new NonWritableChannelException();
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        long l3 = -1L;
        int n2 = -1;
        try {
            FileDescriptor fileDescriptor;
            int n3;
            long l4;
            this.begin();
            n2 = this.threads.add();
            if (!this.isOpen()) {
                MappedByteBuffer mappedByteBuffer = null;
                return mappedByteBuffer;
            }
            while ((l4 = this.nd.size(this.fd)) == -3L && this.isOpen()) {
            }
            if (!this.isOpen()) {
                MappedByteBuffer mappedByteBuffer = null;
                return mappedByteBuffer;
            }
            if (l4 < l + l2) {
                if (!this.writable) {
                    throw new IOException("Channel not open for writing - cannot extend file to required size");
                }
                while ((n3 = this.nd.truncate(this.fd, l + l2)) == -3 && this.isOpen()) {
                }
                if (!this.isOpen()) {
                    MappedByteBuffer mappedByteBuffer = null;
                    return mappedByteBuffer;
                }
            }
            if (l2 == 0L) {
                l3 = 0L;
                FileDescriptor fileDescriptor2 = new FileDescriptor();
                if (!this.writable || n == 0) {
                    MappedByteBuffer mappedByteBuffer = Util.newMappedByteBufferR(0, 0L, fileDescriptor2, null);
                    return mappedByteBuffer;
                }
                MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(0, 0L, fileDescriptor2, null);
                return mappedByteBuffer;
            }
            n3 = (int)(l % allocationGranularity);
            long l5 = l - (long)n3;
            long l6 = l2 + (long)n3;
            try {
                l3 = this.map0(n, l5, l6);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                try {
                    l3 = this.map0(n, l5, l6);
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    throw new IOException("Map failed", outOfMemoryError2);
                }
            }
            try {
                fileDescriptor = this.nd.duplicateForMapping(this.fd);
            }
            catch (IOException iOException) {
                FileChannelImpl.unmap0(l3, l6);
                throw iOException;
            }
            assert (IOStatus.checkAll(l3));
            assert (l3 % allocationGranularity == 0L);
            int n4 = (int)l2;
            Unmapper unmapper = new Unmapper(l3, l6, n4, fileDescriptor);
            if (!this.writable || n == 0) {
                MappedByteBuffer mappedByteBuffer = Util.newMappedByteBufferR(n4, l3 + (long)n3, fileDescriptor, unmapper);
                return mappedByteBuffer;
            }
            MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(n4, l3 + (long)n3, fileDescriptor, unmapper);
            return mappedByteBuffer;
        }
        finally {
            this.threads.remove(n2);
            this.end(IOStatus.checkAll(l3));
        }
    }

    public static JavaNioAccess.BufferPool getMappedBufferPool() {
        return new JavaNioAccess.BufferPool(){

            @Override
            public String getName() {
                return "mapped";
            }

            @Override
            public long getCount() {
                return Unmapper.count;
            }

            @Override
            public long getTotalCapacity() {
                return Unmapper.totalCapacity;
            }

            @Override
            public long getMemoryUsed() {
                return Unmapper.totalSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSharedFileLockTable() {
        if (propertyChecked) return isSharedFileLockTable;
        Class<FileChannelImpl> clazz = FileChannelImpl.class;
        synchronized (FileChannelImpl.class) {
            if (propertyChecked) return isSharedFileLockTable;
            String string = AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.disableSystemWideOverlappingFileLockCheck"));
            isSharedFileLockTable = string == null || string.equals("false");
            propertyChecked = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return isSharedFileLockTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockTable fileLockTable() throws IOException {
        if (this.fileLockTable == null) {
            FileChannelImpl fileChannelImpl = this;
            synchronized (fileChannelImpl) {
                if (this.fileLockTable == null) {
                    if (FileChannelImpl.isSharedFileLockTable()) {
                        int n = this.threads.add();
                        try {
                            this.ensureOpen();
                            this.fileLockTable = FileLockTable.newSharedFileLockTable(this, this.fd);
                        }
                        finally {
                            this.threads.remove(n);
                        }
                    } else {
                        this.fileLockTable = new SimpleFileLockTable();
                    }
                }
            }
        }
        return this.fileLockTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        this.ensureOpen();
        if (bl && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = new FileLockImpl(this, l, l2, bl);
        FileLockTable fileLockTable = this.fileLockTable();
        fileLockTable.add(fileLockImpl);
        boolean bl2 = false;
        int n = -1;
        try {
            int n2;
            this.begin();
            n = this.threads.add();
            if (!this.isOpen()) {
                FileLock fileLock = null;
                return fileLock;
            }
            while ((n2 = this.nd.lock(this.fd, true, l, l2, bl)) == 2 && this.isOpen()) {
            }
            if (this.isOpen()) {
                if (n2 == 1) {
                    assert (bl);
                    FileLockImpl fileLockImpl2 = new FileLockImpl(this, l, l2, false);
                    fileLockTable.replace(fileLockImpl, fileLockImpl2);
                    fileLockImpl = fileLockImpl2;
                }
                bl2 = true;
            }
        }
        finally {
            if (!bl2) {
                fileLockTable.remove(fileLockImpl);
            }
            this.threads.remove(n);
            try {
                this.end(bl2);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                throw new FileLockInterruptionException();
            }
        }
        return fileLockImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        this.ensureOpen();
        if (bl && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = new FileLockImpl(this, l, l2, bl);
        FileLockTable fileLockTable = this.fileLockTable();
        fileLockTable.add(fileLockImpl);
        int n = this.threads.add();
        try {
            int n2;
            try {
                this.ensureOpen();
                n2 = this.nd.lock(this.fd, false, l, l2, bl);
            }
            catch (IOException iOException) {
                fileLockTable.remove(fileLockImpl);
                throw iOException;
            }
            if (n2 == -1) {
                fileLockTable.remove(fileLockImpl);
                FileLock fileLock = null;
                return fileLock;
            }
            if (n2 == 1) {
                assert (bl);
                FileLockImpl fileLockImpl2 = new FileLockImpl(this, l, l2, false);
                fileLockTable.replace(fileLockImpl, fileLockImpl2);
                FileLockImpl fileLockImpl3 = fileLockImpl2;
                return fileLockImpl3;
            }
            FileLockImpl fileLockImpl4 = fileLockImpl;
            return fileLockImpl4;
        }
        finally {
            this.threads.remove(n);
        }
    }

    void release(FileLockImpl fileLockImpl) throws IOException {
        int n = this.threads.add();
        try {
            this.ensureOpen();
            this.nd.release(this.fd, fileLockImpl.position(), fileLockImpl.size());
        }
        finally {
            this.threads.remove(n);
        }
        assert (this.fileLockTable != null);
        this.fileLockTable.remove(fileLockImpl);
    }

    private native long map0(int var1, long var2, long var4) throws IOException;

    private static native int unmap0(long var0, long var2);

    private native long transferTo0(int var1, long var2, long var4, int var6);

    private native long position0(FileDescriptor var1, long var2);

    private static native long initIDs();

    static {
        transferSupported = true;
        pipeSupported = true;
        fileSupported = true;
        IOUtil.load();
        allocationGranularity = FileChannelImpl.initIDs();
    }

    private static class SimpleFileLockTable
    extends FileLockTable {
        private final List<FileLock> lockList = new ArrayList<FileLock>(2);

        private void checkList(long l, long l2) throws OverlappingFileLockException {
            assert (Thread.holdsLock(this.lockList));
            for (FileLock fileLock : this.lockList) {
                if (!fileLock.overlaps(l, l2)) continue;
                throw new OverlappingFileLockException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(FileLock fileLock) throws OverlappingFileLockException {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.checkList(fileLock.position(), fileLock.size());
                this.lockList.add(fileLock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(FileLock fileLock) {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.lockList.remove(fileLock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FileLock> removeAll() {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                ArrayList<FileLock> arrayList = new ArrayList<FileLock>(this.lockList);
                this.lockList.clear();
                return arrayList;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(FileLock fileLock, FileLock fileLock2) {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.lockList.remove(fileLock);
                this.lockList.add(fileLock2);
            }
        }
    }

    private static class Unmapper
    implements Runnable {
        private static final NativeDispatcher nd = new FileDispatcherImpl();
        static volatile int count;
        static volatile long totalSize;
        static volatile long totalCapacity;
        private volatile long address;
        private final long size;
        private final int cap;
        private final FileDescriptor fd;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Unmapper(long l, long l2, int n, FileDescriptor fileDescriptor) {
            assert (l != 0L);
            this.address = l;
            this.size = l2;
            this.cap = n;
            this.fd = fileDescriptor;
            Class<Unmapper> clazz = Unmapper.class;
            synchronized (Unmapper.class) {
                ++count;
                totalSize += l2;
                totalCapacity += (long)n;
                // ** MonitorExit[var7_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            FileChannelImpl.unmap0(this.address, this.size);
            this.address = 0L;
            if (this.fd.valid()) {
                try {
                    nd.close(this.fd);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Class<Unmapper> clazz = Unmapper.class;
            synchronized (Unmapper.class) {
                --count;
                totalSize -= this.size;
                totalCapacity -= (long)this.cap;
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
        }
    }
}

