/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Net;

public class DatagramSocketAdaptor
extends DatagramSocket {
    private final DatagramChannelImpl dc;
    private volatile int timeout = 0;
    private static final DatagramSocketImpl dummyDatagramSocket = new DatagramSocketImpl(){

        @Override
        protected void create() throws SocketException {
        }

        @Override
        protected void bind(int n, InetAddress inetAddress) throws SocketException {
        }

        @Override
        protected void send(DatagramPacket datagramPacket) throws IOException {
        }

        @Override
        protected int peek(InetAddress inetAddress) throws IOException {
            return 0;
        }

        @Override
        protected int peekData(DatagramPacket datagramPacket) throws IOException {
            return 0;
        }

        @Override
        protected void receive(DatagramPacket datagramPacket) throws IOException {
        }

        @Override
        @Deprecated
        protected void setTTL(byte by) throws IOException {
        }

        @Override
        @Deprecated
        protected byte getTTL() throws IOException {
            return 0;
        }

        @Override
        protected void setTimeToLive(int n) throws IOException {
        }

        @Override
        protected int getTimeToLive() throws IOException {
            return 0;
        }

        @Override
        protected void join(InetAddress inetAddress) throws IOException {
        }

        @Override
        protected void leave(InetAddress inetAddress) throws IOException {
        }

        @Override
        protected void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        }

        @Override
        protected void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        }

        @Override
        protected void close() {
        }

        @Override
        public Object getOption(int n) throws SocketException {
            return null;
        }

        @Override
        public void setOption(int n, Object object) throws SocketException {
        }
    };

    private DatagramSocketAdaptor(DatagramChannelImpl datagramChannelImpl) throws IOException {
        super(dummyDatagramSocket);
        this.dc = datagramChannelImpl;
    }

    public static DatagramSocket create(DatagramChannelImpl datagramChannelImpl) {
        try {
            return new DatagramSocketAdaptor(datagramChannelImpl);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private void connectInternal(SocketAddress socketAddress) throws SocketException {
        InetSocketAddress inetSocketAddress = Net.asInetSocketAddress(socketAddress);
        int n = inetSocketAddress.getPort();
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("connect: " + n);
        }
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: null address");
        }
        if (this.isClosed()) {
            return;
        }
        try {
            this.dc.connect(socketAddress);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    @Override
    public void bind(SocketAddress socketAddress) throws SocketException {
        try {
            if (socketAddress == null) {
                socketAddress = new InetSocketAddress(0);
            }
            this.dc.bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    @Override
    public void connect(InetAddress inetAddress, int n) {
        try {
            this.connectInternal(new InetSocketAddress(inetAddress, n));
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public void connect(SocketAddress socketAddress) throws SocketException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        this.connectInternal(socketAddress);
    }

    @Override
    public void disconnect() {
        try {
            this.dc.disconnect();
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    @Override
    public boolean isBound() {
        return this.dc.localAddress() != null;
    }

    @Override
    public boolean isConnected() {
        return this.dc.remoteAddress() != null;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getAddress() : null;
    }

    @Override
    public int getPort() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getPort() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(DatagramPacket datagramPacket) throws IOException {
        Object object = this.dc.blockingLock();
        synchronized (object) {
            if (!this.dc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                DatagramPacket datagramPacket2 = datagramPacket;
                synchronized (datagramPacket2) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                    if (this.dc.isConnected()) {
                        if (datagramPacket.getAddress() == null) {
                            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.dc.remoteAddress();
                            datagramPacket.setPort(inetSocketAddress.getPort());
                            datagramPacket.setAddress(inetSocketAddress.getAddress());
                            this.dc.write(byteBuffer);
                        } else {
                            this.dc.send(byteBuffer, datagramPacket.getSocketAddress());
                        }
                    } else {
                        this.dc.send(byteBuffer, datagramPacket.getSocketAddress());
                    }
                }
            }
            catch (IOException iOException) {
                Net.translateException(iOException);
            }
        }
    }

    private SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        if (this.timeout == 0) {
            return this.dc.receive(byteBuffer);
        }
        this.dc.configureBlocking(false);
        try {
            long l;
            SocketAddress socketAddress = this.dc.receive(byteBuffer);
            if (socketAddress != null) {
                SocketAddress socketAddress2 = socketAddress;
                return socketAddress2;
            }
            long l2 = this.timeout;
            do {
                if (!this.dc.isOpen()) {
                    throw new ClosedChannelException();
                }
                l = System.currentTimeMillis();
                int n = this.dc.poll(1, l2);
                if (n <= 0 || (n & 1) == 0 || (socketAddress = this.dc.receive(byteBuffer)) == null) continue;
                SocketAddress socketAddress3 = socketAddress;
                return socketAddress3;
            } while ((l2 -= System.currentTimeMillis() - l) > 0L);
            throw new SocketTimeoutException();
        }
        finally {
            if (this.dc.isOpen()) {
                this.dc.configureBlocking(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(DatagramPacket datagramPacket) throws IOException {
        Object object = this.dc.blockingLock();
        synchronized (object) {
            if (!this.dc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                DatagramPacket datagramPacket2 = datagramPacket;
                synchronized (datagramPacket2) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                    SocketAddress socketAddress = this.receive(byteBuffer);
                    datagramPacket.setSocketAddress(socketAddress);
                    datagramPacket.setLength(byteBuffer.position() - datagramPacket.getOffset());
                }
            }
            catch (IOException iOException) {
                Net.translateException(iOException);
            }
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        SocketAddress socketAddress = this.dc.localAddress();
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkConnect(inetAddress.getHostAddress(), -1);
            }
            catch (SecurityException securityException) {
                return new InetSocketAddress(0).getAddress();
            }
        }
        return inetAddress;
    }

    @Override
    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            SocketAddress socketAddress = this.dc.getLocalAddress();
            if (socketAddress != null) {
                return ((InetSocketAddress)socketAddress).getPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        this.timeout = n;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    private void setBooleanOption(SocketOption<Boolean> socketOption, boolean bl) throws SocketException {
        try {
            this.dc.setOption((SocketOption)socketOption, (Object)bl);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private void setIntOption(SocketOption<Integer> socketOption, int n) throws SocketException {
        try {
            this.dc.setOption((SocketOption)socketOption, (Object)n);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private boolean getBooleanOption(SocketOption<Boolean> socketOption) throws SocketException {
        try {
            return this.dc.getOption(socketOption);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return false;
        }
    }

    private int getIntOption(SocketOption<Integer> socketOption) throws SocketException {
        try {
            return this.dc.getOption(socketOption);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return -1;
        }
    }

    @Override
    public void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setIntOption(StandardSocketOptions.SO_SNDBUF, n);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_SNDBUF);
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setIntOption(StandardSocketOptions.SO_RCVBUF, n);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_RCVBUF);
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_REUSEADDR, bl);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_REUSEADDR);
    }

    @Override
    public void setBroadcast(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_BROADCAST, bl);
    }

    @Override
    public boolean getBroadcast() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_BROADCAST);
    }

    @Override
    public void setTrafficClass(int n) throws SocketException {
        this.setIntOption(StandardSocketOptions.IP_TOS, n);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.getIntOption(StandardSocketOptions.IP_TOS);
    }

    @Override
    public void close() {
        try {
            this.dc.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    @Override
    public boolean isClosed() {
        return !this.dc.isOpen();
    }

    @Override
    public DatagramChannel getChannel() {
        return this.dc;
    }
}

