/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import sun.misc.Unsafe;

public class CompletableFuture<T>
implements Future<T>,
CompletionStage<T> {
    static final AltResult NIL = new AltResult(null);
    volatile Object result;
    volatile WaitNode waiters;
    volatile CompletionNode completions;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int SPINS = NCPU > 1 ? 256 : 0;
    private static final Unsafe UNSAFE;
    private static final long RESULT;
    private static final long WAITERS;
    private static final long COMPLETIONS;

    final void postComplete() {
        CompletionNode completionNode;
        WaitNode waitNode;
        while ((waitNode = this.waiters) != null) {
            Thread thread;
            if (!UNSAFE.compareAndSwapObject(this, WAITERS, waitNode, waitNode.next) || (thread = waitNode.thread) == null) continue;
            waitNode.thread = null;
            LockSupport.unpark(thread);
        }
        while ((completionNode = this.completions) != null) {
            Completion completion;
            if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, completionNode, completionNode.next) || (completion = completionNode.completion) == null) continue;
            completion.run();
        }
    }

    final void internalComplete(T t, Throwable throwable) {
        if (this.result == null) {
            UNSAFE.compareAndSwapObject(this, RESULT, null, throwable == null ? (t == null ? NIL : t) : new AltResult(throwable instanceof CompletionException ? throwable : new CompletionException(throwable)));
        }
        this.postComplete();
    }

    final void helpPostComplete() {
        if (this.result != null) {
            this.postComplete();
        }
    }

    private Object waitingGet(boolean bl) {
        WaitNode waitNode = null;
        boolean bl2 = false;
        int n = SPINS;
        while (true) {
            Object object;
            if ((object = this.result) != null) {
                if (waitNode != null) {
                    waitNode.thread = null;
                    if (waitNode.interruptControl < 0) {
                        if (bl) {
                            this.removeWaiter(waitNode);
                            return null;
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                this.postComplete();
                return object;
            }
            if (n > 0) {
                int n2 = ThreadLocalRandom.nextSecondarySeed();
                if (n2 == 0) {
                    n2 = ThreadLocalRandom.current().nextInt();
                }
                if (n2 < 0) continue;
                --n;
                continue;
            }
            if (waitNode == null) {
                waitNode = new WaitNode(bl, 0L, 0L);
                continue;
            }
            if (!bl2) {
                waitNode.next = this.waiters;
                bl2 = UNSAFE.compareAndSwapObject(this, WAITERS, waitNode.next, waitNode);
                continue;
            }
            if (bl && waitNode.interruptControl < 0) {
                this.removeWaiter(waitNode);
                return null;
            }
            if (waitNode.thread == null || this.result != null) continue;
            try {
                ForkJoinPool.managedBlock(waitNode);
                continue;
            }
            catch (InterruptedException interruptedException) {
                waitNode.interruptControl = -1;
                continue;
            }
            break;
        }
    }

    private Object timedAwaitDone(long l) throws InterruptedException, TimeoutException {
        WaitNode waitNode = null;
        boolean bl = false;
        while (true) {
            Object object;
            if ((object = this.result) != null) {
                if (waitNode != null) {
                    waitNode.thread = null;
                    if (waitNode.interruptControl < 0) {
                        this.removeWaiter(waitNode);
                        throw new InterruptedException();
                    }
                }
                this.postComplete();
                return object;
            }
            if (waitNode == null) {
                if (l <= 0L) {
                    throw new TimeoutException();
                }
                long l2 = System.nanoTime() + l;
                waitNode = new WaitNode(true, l, l2 == 0L ? 1L : l2);
                continue;
            }
            if (!bl) {
                waitNode.next = this.waiters;
                bl = UNSAFE.compareAndSwapObject(this, WAITERS, waitNode.next, waitNode);
                continue;
            }
            if (waitNode.interruptControl < 0) {
                this.removeWaiter(waitNode);
                throw new InterruptedException();
            }
            if (waitNode.nanos <= 0L) {
                if (this.result != null) continue;
                this.removeWaiter(waitNode);
                throw new TimeoutException();
            }
            if (waitNode.thread == null || this.result != null) continue;
            try {
                ForkJoinPool.managedBlock(waitNode);
                continue;
            }
            catch (InterruptedException interruptedException) {
                waitNode.interruptControl = -1;
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(WaitNode var1_1) {
        if (var1_1 != null) {
            var1_1.thread = null;
            block0: while (true) {
                var2_2 = null;
                var3_3 = this.waiters;
                while (var3_3 != null) {
                    var4_4 = var3_3.next;
                    if (var3_3.thread != null) {
                        var2_2 = var3_3;
                    } else if (var2_2 != null) {
                        var2_2.next = var4_4;
                        if (var2_2.thread == null) {
                            continue block0;
                        }
                    } else {
                        if (CompletableFuture.UNSAFE.compareAndSwapObject(this, CompletableFuture.WAITERS, var3_3, var4_4)) ** break;
                        continue block0;
                    }
                    var3_3 = var4_4;
                }
                break;
            }
        }
    }

    static void execAsync(Executor executor, Async async) {
        if (executor == ForkJoinPool.commonPool() && ForkJoinPool.getCommonPoolParallelism() <= 1) {
            new Thread(async).start();
        } else {
            executor.execute(async);
        }
    }

    private <U> CompletableFuture<U> doThenApply(Function<? super T, ? extends U> function, Executor executor) {
        Object object;
        if (function == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        ThenApply<T, U> thenApply = null;
        Object object2 = this.result;
        if (object2 == null) {
            thenApply = new ThenApply<T, U>(this, function, completableFuture, executor);
            object = new CompletionNode(thenApply);
            while ((object2 = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)object).next = this.completions, object)) {
            }
        }
        if (object2 != null && (thenApply == null || thenApply.compareAndSet(0, 1))) {
            Object object3;
            Throwable throwable;
            if (object2 instanceof AltResult) {
                throwable = ((AltResult)object2).ex;
                object = null;
            } else {
                throwable = null;
                object = object3 = object2;
            }
            object3 = null;
            if (throwable == null) {
                try {
                    if (executor != null) {
                        CompletableFuture.execAsync(executor, new AsyncApply<T, U>(object, function, completableFuture));
                    } else {
                        object3 = function.apply(object);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            if (executor == null || throwable != null) {
                completableFuture.internalComplete(object3, throwable);
            }
        }
        this.helpPostComplete();
        return completableFuture;
    }

    private CompletableFuture<Void> doThenAccept(Consumer<? super T> consumer, Executor executor) {
        Object object;
        if (consumer == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ThenAccept<T> thenAccept = null;
        Object object2 = this.result;
        if (object2 == null) {
            thenAccept = new ThenAccept<T>(this, consumer, completableFuture, executor);
            object = new CompletionNode(thenAccept);
            while ((object2 = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)object).next = this.completions, object)) {
            }
        }
        if (object2 != null && (thenAccept == null || thenAccept.compareAndSet(0, 1))) {
            Throwable throwable;
            if (object2 instanceof AltResult) {
                throwable = ((AltResult)object2).ex;
                object = null;
            } else {
                Object object3;
                throwable = null;
                object = object3 = object2;
            }
            if (throwable == null) {
                try {
                    if (executor != null) {
                        CompletableFuture.execAsync(executor, new AsyncAccept<T>(object, consumer, completableFuture));
                    } else {
                        consumer.accept(object);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            if (executor == null || throwable != null) {
                completableFuture.internalComplete(null, throwable);
            }
        }
        this.helpPostComplete();
        return completableFuture;
    }

    private CompletableFuture<Void> doThenRun(Runnable runnable, Executor executor) {
        Object object;
        if (runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        AtomicInteger atomicInteger = null;
        Object object2 = this.result;
        if (object2 == null) {
            atomicInteger = new ThenRun(this, runnable, completableFuture, executor);
            object = new CompletionNode((Completion)atomicInteger);
            while ((object2 = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)object).next = this.completions, object)) {
            }
        }
        if (object2 != null && (atomicInteger == null || atomicInteger.compareAndSet(0, 1))) {
            object = object2 instanceof AltResult ? ((AltResult)object2).ex : null;
            if (object == null) {
                try {
                    if (executor != null) {
                        CompletableFuture.execAsync(executor, new AsyncRun(runnable, completableFuture));
                    } else {
                        runnable.run();
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                }
            }
            if (executor == null || object != null) {
                completableFuture.internalComplete(null, (Throwable)object);
            }
        }
        this.helpPostComplete();
        return completableFuture;
    }

    private <U, V> CompletableFuture<V> doThenCombine(CompletableFuture<? extends U> completableFuture, BiFunction<? super T, ? super U, ? extends V> biFunction, Executor executor) {
        Object object;
        Object object2;
        if (completableFuture == null || biFunction == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> completableFuture2 = new CompletableFuture<Object>();
        ThenCombine<T, U, V> thenCombine = null;
        Object object3 = null;
        Object object4 = this.result;
        if (object4 == null || (object3 = completableFuture.result) == null) {
            thenCombine = new ThenCombine<T, U, V>(this, completableFuture, biFunction, completableFuture2, executor);
            object2 = null;
            object = new CompletionNode(thenCombine);
            while (object4 == null && (object4 = this.result) == null || object3 == null && (object3 = completableFuture.result) == null) {
                if (object2 != null) {
                    if (object3 == null && !UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, ((CompletionNode)object2).next = completableFuture.completions, object2)) continue;
                    break;
                }
                if (object4 == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)object).next = this.completions, object)) continue;
                if (object3 != null) break;
                object2 = new CompletionNode(thenCombine);
            }
        }
        if (object4 != null && object3 != null && (thenCombine == null || thenCombine.compareAndSet(0, 1))) {
            Object object5;
            Throwable throwable;
            if (object4 instanceof AltResult) {
                throwable = ((AltResult)object4).ex;
                object2 = null;
            } else {
                throwable = null;
                object2 = object5 = object4;
            }
            if (throwable != null) {
                object = null;
            } else if (object3 instanceof AltResult) {
                throwable = ((AltResult)object3).ex;
                object = null;
            } else {
                object = object5 = object3;
            }
            object5 = null;
            if (throwable == null) {
                try {
                    if (executor != null) {
                        CompletableFuture.execAsync(executor, new AsyncCombine<T, U, V>(object2, object, biFunction, completableFuture2));
                    } else {
                        object5 = biFunction.apply(object2, object);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            if (executor == null || throwable != null) {
                completableFuture2.internalComplete(object5, throwable);
            }
        }
        this.helpPostComplete();
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private <U> CompletableFuture<Void> doThenAcceptBoth(CompletableFuture<? extends U> completableFuture, BiConsumer<? super T, ? super U> biConsumer, Executor executor) {
        Object object;
        Object object2;
        if (completableFuture == null || biConsumer == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture2 = new CompletableFuture<Void>();
        ThenAcceptBoth<T, U> thenAcceptBoth = null;
        Object object3 = null;
        Object object4 = this.result;
        if (object4 == null || (object3 = completableFuture.result) == null) {
            thenAcceptBoth = new ThenAcceptBoth<T, U>(this, completableFuture, biConsumer, completableFuture2, executor);
            object2 = null;
            object = new CompletionNode(thenAcceptBoth);
            while (object4 == null && (object4 = this.result) == null || object3 == null && (object3 = completableFuture.result) == null) {
                if (object2 != null) {
                    if (object3 == null && !UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, ((CompletionNode)object2).next = completableFuture.completions, object2)) continue;
                    break;
                }
                if (object4 == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)object).next = this.completions, object)) continue;
                if (object3 != null) break;
                object2 = new CompletionNode(thenAcceptBoth);
            }
        }
        if (object4 != null && object3 != null && (thenAcceptBoth == null || thenAcceptBoth.compareAndSet(0, 1))) {
            Object object5;
            Throwable throwable;
            if (object4 instanceof AltResult) {
                throwable = ((AltResult)object4).ex;
                object2 = null;
            } else {
                throwable = null;
                object2 = object5 = object4;
            }
            if (throwable != null) {
                object = null;
            } else if (object3 instanceof AltResult) {
                throwable = ((AltResult)object3).ex;
                object = null;
            } else {
                object = object5 = object3;
            }
            if (throwable == null) {
                try {
                    if (executor != null) {
                        CompletableFuture.execAsync(executor, new AsyncAcceptBoth<T, U>(object2, object, biConsumer, completableFuture2));
                    } else {
                        biConsumer.accept(object2, object);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            if (executor == null || throwable != null) {
                completableFuture2.internalComplete(null, throwable);
            }
        }
        this.helpPostComplete();
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private CompletableFuture<Void> doRunAfterBoth(CompletableFuture<?> completableFuture, Runnable runnable, Executor executor) {
        Object object;
        if (completableFuture == null || runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture2 = new CompletableFuture<Void>();
        RunAfterBoth runAfterBoth = null;
        Object object2 = null;
        Object object3 = this.result;
        if (object3 == null || (object2 = completableFuture.result) == null) {
            runAfterBoth = new RunAfterBoth(this, completableFuture, runnable, completableFuture2, executor);
            object = null;
            CompletionNode completionNode = new CompletionNode(runAfterBoth);
            while (object3 == null && (object3 = this.result) == null || object2 == null && (object2 = completableFuture.result) == null) {
                if (object != null) {
                    if (object2 == null && !UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, ((CompletionNode)object).next = completableFuture.completions, object)) continue;
                    break;
                }
                if (object3 == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, completionNode.next = this.completions, completionNode)) continue;
                if (object2 != null) break;
                object = new CompletionNode(runAfterBoth);
            }
        }
        if (object3 != null && object2 != null && (runAfterBoth == null || runAfterBoth.compareAndSet(0, 1))) {
            object = object3 instanceof AltResult ? ((AltResult)object3).ex : null;
            if (object == null && object2 instanceof AltResult) {
                object = ((AltResult)object2).ex;
            }
            if (object == null) {
                try {
                    if (executor != null) {
                        CompletableFuture.execAsync(executor, new AsyncRun(runnable, completableFuture2));
                    } else {
                        runnable.run();
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                }
            }
            if (executor == null || object != null) {
                completableFuture2.internalComplete(null, (Throwable)object);
            }
        }
        this.helpPostComplete();
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private <U> CompletableFuture<U> doApplyToEither(CompletableFuture<? extends T> completableFuture, Function<? super T, U> function, Executor executor) {
        Object object;
        Object object2;
        if (completableFuture == null || function == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> completableFuture2 = new CompletableFuture<Object>();
        ApplyToEither<T, U> applyToEither = null;
        Object object3 = this.result;
        if (object3 == null && (object3 = completableFuture.result) == null) {
            applyToEither = new ApplyToEither<T, U>(this, completableFuture, function, completableFuture2, executor);
            object2 = null;
            object = new CompletionNode(applyToEither);
            while ((object3 = this.result) == null && (object3 = completableFuture.result) == null) {
                if (object2 != null) {
                    ((CompletionNode)object2).next = completableFuture.completions;
                    if (!UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, ((CompletionNode)object2).next, object2)) continue;
                    break;
                }
                ((CompletionNode)object).next = this.completions;
                if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)object).next, object)) continue;
                object2 = new CompletionNode(applyToEither);
            }
        }
        if (object3 != null && (applyToEither == null || applyToEither.compareAndSet(0, 1))) {
            Object object4;
            if (object3 instanceof AltResult) {
                object = ((AltResult)object3).ex;
                object2 = null;
            } else {
                object = null;
                object2 = object4 = object3;
            }
            object4 = null;
            if (object == null) {
                try {
                    if (executor != null) {
                        CompletableFuture.execAsync(executor, new AsyncApply<T, U>(object2, function, completableFuture2));
                    } else {
                        object4 = function.apply(object2);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                }
            }
            if (executor == null || object != null) {
                completableFuture2.internalComplete(object4, (Throwable)object);
            }
        }
        this.helpPostComplete();
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private CompletableFuture<Void> doAcceptEither(CompletableFuture<? extends T> completableFuture, Consumer<? super T> consumer, Executor executor) {
        Object object;
        Object object2;
        if (completableFuture == null || consumer == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture2 = new CompletableFuture<Void>();
        AcceptEither<T> acceptEither = null;
        Object object3 = this.result;
        if (object3 == null && (object3 = completableFuture.result) == null) {
            acceptEither = new AcceptEither<T>(this, completableFuture, consumer, completableFuture2, executor);
            object2 = null;
            object = new CompletionNode(acceptEither);
            while ((object3 = this.result) == null && (object3 = completableFuture.result) == null) {
                if (object2 != null) {
                    ((CompletionNode)object2).next = completableFuture.completions;
                    if (!UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, ((CompletionNode)object2).next, object2)) continue;
                    break;
                }
                ((CompletionNode)object).next = this.completions;
                if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)object).next, object)) continue;
                object2 = new CompletionNode(acceptEither);
            }
        }
        if (object3 != null && (acceptEither == null || acceptEither.compareAndSet(0, 1))) {
            if (object3 instanceof AltResult) {
                object = ((AltResult)object3).ex;
                object2 = null;
            } else {
                Object object4;
                object = null;
                object2 = object4 = object3;
            }
            if (object == null) {
                try {
                    if (executor != null) {
                        CompletableFuture.execAsync(executor, new AsyncAccept<T>(object2, consumer, completableFuture2));
                    } else {
                        consumer.accept(object2);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                }
            }
            if (executor == null || object != null) {
                completableFuture2.internalComplete(null, (Throwable)object);
            }
        }
        this.helpPostComplete();
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private CompletableFuture<Void> doRunAfterEither(CompletableFuture<?> completableFuture, Runnable runnable, Executor executor) {
        Object object;
        if (completableFuture == null || runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture2 = new CompletableFuture<Void>();
        AtomicInteger atomicInteger = null;
        Object object2 = this.result;
        if (object2 == null && (object2 = completableFuture.result) == null) {
            atomicInteger = new RunAfterEither(this, completableFuture, runnable, completableFuture2, executor);
            object = null;
            CompletionNode completionNode = new CompletionNode((Completion)atomicInteger);
            while ((object2 = this.result) == null && (object2 = completableFuture.result) == null) {
                if (object != null) {
                    ((CompletionNode)object).next = completableFuture.completions;
                    if (!UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, ((CompletionNode)object).next, object)) continue;
                    break;
                }
                completionNode.next = this.completions;
                if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, completionNode.next, completionNode)) continue;
                object = new CompletionNode((Completion)atomicInteger);
            }
        }
        if (object2 != null && (atomicInteger == null || atomicInteger.compareAndSet(0, 1))) {
            object = object2 instanceof AltResult ? ((AltResult)object2).ex : null;
            if (object == null) {
                try {
                    if (executor != null) {
                        CompletableFuture.execAsync(executor, new AsyncRun(runnable, completableFuture2));
                    } else {
                        runnable.run();
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                }
            }
            if (executor == null || object != null) {
                completableFuture2.internalComplete(null, (Throwable)object);
            }
        }
        this.helpPostComplete();
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private <U> CompletableFuture<U> doThenCompose(Function<? super T, ? extends CompletionStage<U>> function, Executor executor) {
        CompletionStage<U> completionStage;
        if (function == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> completableFuture = null;
        ThenCompose<T, T> thenCompose = null;
        CompletionStage<U> completionStage2 = this.result;
        if (completionStage2 == null) {
            completableFuture = new CompletableFuture<T>();
            thenCompose = new ThenCompose<T, T>(this, function, completableFuture, executor);
            completionStage = new CompletionNode(thenCompose);
            while ((completionStage2 = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)((Object)completionStage)).next = this.completions, completionStage)) {
            }
        }
        if (completionStage2 != null && (thenCompose == null || thenCompose.compareAndSet(0, 1))) {
            CompletionStage<U> completionStage3;
            Throwable throwable;
            if (completionStage2 instanceof AltResult) {
                throwable = ((AltResult)((Object)completionStage2)).ex;
                completionStage = null;
            } else {
                throwable = null;
                completionStage = completionStage3 = completionStage2;
            }
            if (throwable == null) {
                if (executor != null) {
                    if (completableFuture == null) {
                        completableFuture = new CompletableFuture<T>();
                    }
                    CompletableFuture.execAsync(executor, new AsyncCompose<T, T>(completionStage, function, completableFuture));
                } else {
                    try {
                        completionStage3 = function.apply(completionStage);
                        if (completionStage3 == null || (completableFuture = completionStage3.toCompletableFuture()) == null) {
                            throwable = new NullPointerException();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                }
            }
            if (completableFuture == null) {
                completableFuture = new CompletableFuture<T>();
            }
            if (throwable != null) {
                completableFuture.internalComplete(null, throwable);
            }
        }
        this.helpPostComplete();
        completableFuture.helpPostComplete();
        return completableFuture;
    }

    private CompletableFuture<T> doWhenComplete(BiConsumer<? super T, ? super Throwable> biConsumer, Executor executor) {
        Object object;
        if (biConsumer == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        WhenCompleteCompletion<T> whenCompleteCompletion = null;
        Object object2 = this.result;
        if (object2 == null) {
            whenCompleteCompletion = new WhenCompleteCompletion<T>(this, biConsumer, completableFuture, executor);
            object = new CompletionNode(whenCompleteCompletion);
            while ((object2 = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)object).next = this.completions, object)) {
            }
        }
        if (object2 != null && (whenCompleteCompletion == null || whenCompleteCompletion.compareAndSet(0, 1))) {
            Object object3;
            Throwable throwable;
            if (object2 instanceof AltResult) {
                throwable = ((AltResult)object2).ex;
                object = null;
            } else {
                throwable = null;
                object = object3 = object2;
            }
            object3 = null;
            try {
                if (executor != null) {
                    CompletableFuture.execAsync(executor, new AsyncWhenComplete<T>(object, throwable, biConsumer, completableFuture));
                } else {
                    biConsumer.accept(object, throwable);
                }
            }
            catch (Throwable throwable2) {
                object3 = throwable2;
            }
            if (executor == null || object3 != null) {
                completableFuture.internalComplete(object, (Throwable)(throwable != null ? throwable : object3));
            }
        }
        this.helpPostComplete();
        return completableFuture;
    }

    private <U> CompletableFuture<U> doHandle(BiFunction<? super T, Throwable, ? extends U> biFunction, Executor executor) {
        Object object;
        if (biFunction == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        HandleCompletion<T, U> handleCompletion = null;
        Object object2 = this.result;
        if (object2 == null) {
            handleCompletion = new HandleCompletion<T, U>(this, biFunction, completableFuture, executor);
            object = new CompletionNode(handleCompletion);
            while ((object2 = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)object).next = this.completions, object)) {
            }
        }
        if (object2 != null && (handleCompletion == null || handleCompletion.compareAndSet(0, 1))) {
            Object object3;
            Throwable throwable;
            if (object2 instanceof AltResult) {
                throwable = ((AltResult)object2).ex;
                object = null;
            } else {
                throwable = null;
                object = object3 = object2;
            }
            object3 = null;
            Throwable throwable2 = null;
            try {
                if (executor != null) {
                    CompletableFuture.execAsync(executor, new AsyncCombine<T, Throwable, U>(object, throwable, biFunction, completableFuture));
                } else {
                    object3 = biFunction.apply(object, throwable);
                    throwable2 = null;
                }
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                object3 = null;
            }
            if (executor == null || throwable2 != null) {
                completableFuture.internalComplete(object3, throwable2);
            }
        }
        this.helpPostComplete();
        return completableFuture;
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        if (supplier == null) {
            throw new NullPointerException();
        }
        CompletableFuture completableFuture = new CompletableFuture();
        CompletableFuture.execAsync(ForkJoinPool.commonPool(), new AsyncSupply<U>(supplier, completableFuture));
        return completableFuture;
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        if (executor == null || supplier == null) {
            throw new NullPointerException();
        }
        CompletableFuture completableFuture = new CompletableFuture();
        CompletableFuture.execAsync(executor, new AsyncSupply<U>(supplier, completableFuture));
        return completableFuture;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        CompletableFuture.execAsync(ForkJoinPool.commonPool(), new AsyncRun(runnable, completableFuture));
        return completableFuture;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        if (executor == null || runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        CompletableFuture.execAsync(executor, new AsyncRun(runnable, completableFuture));
        return completableFuture;
    }

    public static <U> CompletableFuture<U> completedFuture(U u) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.result = u == null ? NIL : u;
        return completableFuture;
    }

    @Override
    public boolean isDone() {
        return this.result != null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Throwable throwable;
        Object object = this.result;
        if (object == null && (object = this.waitingGet(true)) == null) {
            throw new InterruptedException();
        }
        if (!(object instanceof AltResult)) {
            Object object2 = object;
            return (T)object2;
        }
        Throwable throwable2 = ((AltResult)object).ex;
        if (throwable2 == null) {
            return null;
        }
        if (throwable2 instanceof CancellationException) {
            throw (CancellationException)throwable2;
        }
        if (throwable2 instanceof CompletionException && (throwable = throwable2.getCause()) != null) {
            throwable2 = throwable;
        }
        throw new ExecutionException(throwable2);
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Throwable throwable;
        long l2 = timeUnit.toNanos(l);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.result;
        if (object == null) {
            object = this.timedAwaitDone(l2);
        }
        if (!(object instanceof AltResult)) {
            Object object2 = object;
            return (T)object2;
        }
        Throwable throwable2 = ((AltResult)object).ex;
        if (throwable2 == null) {
            return null;
        }
        if (throwable2 instanceof CancellationException) {
            throw (CancellationException)throwable2;
        }
        if (throwable2 instanceof CompletionException && (throwable = throwable2.getCause()) != null) {
            throwable2 = throwable;
        }
        throw new ExecutionException(throwable2);
    }

    public T join() {
        Object object = this.result;
        if (object == null) {
            object = this.waitingGet(false);
        }
        if (!(object instanceof AltResult)) {
            Object object2 = object;
            return (T)object2;
        }
        Throwable throwable = ((AltResult)object).ex;
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof CancellationException) {
            throw (CancellationException)throwable;
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public T getNow(T t) {
        Object object = this.result;
        if (object == null) {
            return t;
        }
        if (!(object instanceof AltResult)) {
            Object object2 = object;
            return (T)object2;
        }
        Throwable throwable = ((AltResult)object).ex;
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof CancellationException) {
            throw (CancellationException)throwable;
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public boolean complete(T t) {
        boolean bl = this.result == null && UNSAFE.compareAndSwapObject(this, RESULT, null, t == null ? NIL : t);
        this.postComplete();
        return bl;
    }

    public boolean completeExceptionally(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException();
        }
        boolean bl = this.result == null && UNSAFE.compareAndSwapObject(this, RESULT, null, new AltResult(throwable));
        this.postComplete();
        return bl;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> function) {
        return this.doThenApply(function, null);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> function) {
        return this.doThenApply(function, ForkJoinPool.commonPool());
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> function, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenApply(function, executor);
    }

    public CompletableFuture<Void> thenAccept(Consumer<? super T> consumer) {
        return this.doThenAccept(consumer, null);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> consumer) {
        return this.doThenAccept(consumer, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> consumer, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenAccept(consumer, executor);
    }

    public CompletableFuture<Void> thenRun(Runnable runnable) {
        return this.doThenRun(runnable, null);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable runnable) {
        return this.doThenRun(runnable, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> thenRunAsync(Runnable runnable, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenRun(runnable, executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        return this.doThenCombine(completionStage.toCompletableFuture(), biFunction, null);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        return this.doThenCombine(completionStage.toCompletableFuture(), biFunction, ForkJoinPool.commonPool());
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenCombine(completionStage.toCompletableFuture(), biFunction, executor);
    }

    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        return this.doThenAcceptBoth(completionStage.toCompletableFuture(), biConsumer, null);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        return this.doThenAcceptBoth(completionStage.toCompletableFuture(), biConsumer, ForkJoinPool.commonPool());
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenAcceptBoth(completionStage.toCompletableFuture(), biConsumer, executor);
    }

    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> completionStage, Runnable runnable) {
        return this.doRunAfterBoth(completionStage.toCompletableFuture(), runnable, null);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> completionStage, Runnable runnable) {
        return this.doRunAfterBoth(completionStage.toCompletableFuture(), runnable, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> completionStage, Runnable runnable, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doRunAfterBoth(completionStage.toCompletableFuture(), runnable, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> completionStage, Function<? super T, U> function) {
        return this.doApplyToEither(completionStage.toCompletableFuture(), function, null);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> completionStage, Function<? super T, U> function) {
        return this.doApplyToEither(completionStage.toCompletableFuture(), function, ForkJoinPool.commonPool());
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> completionStage, Function<? super T, U> function, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doApplyToEither(completionStage.toCompletableFuture(), function, executor);
    }

    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer) {
        return this.doAcceptEither(completionStage.toCompletableFuture(), consumer, null);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer) {
        return this.doAcceptEither(completionStage.toCompletableFuture(), consumer, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doAcceptEither(completionStage.toCompletableFuture(), consumer, executor);
    }

    public CompletableFuture<Void> runAfterEither(CompletionStage<?> completionStage, Runnable runnable) {
        return this.doRunAfterEither(completionStage.toCompletableFuture(), runnable, null);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> completionStage, Runnable runnable) {
        return this.doRunAfterEither(completionStage.toCompletableFuture(), runnable, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> completionStage, Runnable runnable, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doRunAfterEither(completionStage.toCompletableFuture(), runnable, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> function) {
        return this.doThenCompose(function, null);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> function) {
        return this.doThenCompose(function, ForkJoinPool.commonPool());
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> function, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenCompose(function, executor);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> biConsumer) {
        return this.doWhenComplete(biConsumer, null);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> biConsumer) {
        return this.doWhenComplete(biConsumer, ForkJoinPool.commonPool());
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> biConsumer, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doWhenComplete(biConsumer, executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> biFunction) {
        return this.doHandle(biFunction, null);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> biFunction) {
        return this.doHandle(biFunction, ForkJoinPool.commonPool());
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> biFunction, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doHandle(biFunction, executor);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> function) {
        Object object;
        if (function == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        ExceptionCompletion<T> exceptionCompletion = null;
        Object object2 = this.result;
        if (object2 == null) {
            exceptionCompletion = new ExceptionCompletion<T>(this, function, completableFuture);
            object = new CompletionNode(exceptionCompletion);
            while ((object2 = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, ((CompletionNode)object).next = this.completions, object)) {
            }
        }
        if (object2 != null && (exceptionCompletion == null || exceptionCompletion.compareAndSet(0, 1))) {
            object = null;
            Throwable throwable = null;
            if (object2 instanceof AltResult) {
                Throwable throwable2 = ((AltResult)object2).ex;
                if (throwable2 != null) {
                    try {
                        object = function.apply(throwable2);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                    }
                }
            } else {
                Object object3;
                object = object3 = object2;
            }
            completableFuture.internalComplete(object, throwable);
        }
        this.helpPostComplete();
        return completableFuture;
    }

    public static CompletableFuture<Void> allOf(CompletableFuture<?> ... completableFutureArray) {
        int n = completableFutureArray.length;
        if (n > 1) {
            return CompletableFuture.allTree(completableFutureArray, 0, n - 1);
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (n == 0) {
            completableFuture.result = NIL;
        } else {
            Object object;
            CompletableFuture<?> completableFuture2 = completableFutureArray[0];
            if (completableFuture2 == null) {
                throw new NullPointerException();
            }
            ThenPropagate thenPropagate = null;
            CompletionNode completionNode = null;
            while ((object = completableFuture2.result) == null) {
                if (thenPropagate == null) {
                    thenPropagate = new ThenPropagate(completableFuture2, completableFuture);
                    continue;
                }
                if (completionNode == null) {
                    completionNode = new CompletionNode(thenPropagate);
                    continue;
                }
                completionNode.next = completableFuture2.completions;
                if (!UNSAFE.compareAndSwapObject(completableFuture2, COMPLETIONS, completionNode.next, completionNode)) continue;
            }
            if (object != null && (thenPropagate == null || thenPropagate.compareAndSet(0, 1))) {
                completableFuture.internalComplete(null, object instanceof AltResult ? ((AltResult)object).ex : null);
            }
            completableFuture2.helpPostComplete();
        }
        return completableFuture;
    }

    private static CompletableFuture<Void> allTree(CompletableFuture<?>[] completableFutureArray, int n, int n2) {
        CompletableFuture<?> completableFuture;
        int n3 = n + n2 >>> 1;
        CompletableFuture<Object> completableFuture2 = n == n3 ? completableFutureArray[n] : CompletableFuture.allTree(completableFutureArray, n, n3);
        if (completableFuture2 == null || (completableFuture = n2 == n3 + 1 ? completableFutureArray[n2] : CompletableFuture.allTree(completableFutureArray, n3 + 1, n2)) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture3 = new CompletableFuture<Void>();
        AndCompletion andCompletion = null;
        CompletionNode completionNode = null;
        CompletionNode completionNode2 = null;
        Object object = null;
        Object object2 = null;
        while ((object = completableFuture2.result) == null || (object2 = completableFuture.result) == null) {
            if (andCompletion == null) {
                andCompletion = new AndCompletion(completableFuture2, completableFuture, completableFuture3);
                continue;
            }
            if (completionNode == null) {
                completionNode = new CompletionNode(andCompletion);
                continue;
            }
            if (completionNode2 == null) {
                completionNode.next = completableFuture2.completions;
                if (!UNSAFE.compareAndSwapObject(completableFuture2, COMPLETIONS, completionNode.next, completionNode)) continue;
                completionNode2 = new CompletionNode(andCompletion);
                continue;
            }
            completionNode2.next = completableFuture.completions;
            if (!UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, completionNode2.next, completionNode2)) continue;
        }
        if (!(object == null && (object = completableFuture2.result) == null || object2 == null && (object2 = completableFuture.result) == null || andCompletion != null && !andCompletion.compareAndSet(0, 1))) {
            Throwable throwable = object instanceof AltResult ? ((AltResult)object).ex : null;
            if (throwable == null && object2 instanceof AltResult) {
                throwable = ((AltResult)object2).ex;
            }
            completableFuture3.internalComplete(null, throwable);
        }
        completableFuture2.helpPostComplete();
        completableFuture.helpPostComplete();
        return completableFuture3;
    }

    public static CompletableFuture<Object> anyOf(CompletableFuture<?> ... completableFutureArray) {
        int n = completableFutureArray.length;
        if (n > 1) {
            return CompletableFuture.anyTree(completableFutureArray, 0, n - 1);
        }
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        if (n != 0) {
            Object object;
            CompletableFuture<?> completableFuture2 = completableFutureArray[0];
            if (completableFuture2 == null) {
                throw new NullPointerException();
            }
            ThenCopy<Object> thenCopy = null;
            CompletionNode completionNode = null;
            while ((object = completableFuture2.result) == null) {
                if (thenCopy == null) {
                    thenCopy = new ThenCopy<Object>(completableFuture2, completableFuture);
                    continue;
                }
                if (completionNode == null) {
                    completionNode = new CompletionNode(thenCopy);
                    continue;
                }
                completionNode.next = completableFuture2.completions;
                if (!UNSAFE.compareAndSwapObject(completableFuture2, COMPLETIONS, completionNode.next, completionNode)) continue;
            }
            if (object != null && (thenCopy == null || thenCopy.compareAndSet(0, 1))) {
                Object object2;
                Throwable throwable;
                if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object2 = null;
                } else {
                    throwable = null;
                    object2 = object;
                }
                completableFuture.internalComplete(object2, throwable);
            }
            completableFuture2.helpPostComplete();
        }
        return completableFuture;
    }

    private static CompletableFuture<Object> anyTree(CompletableFuture<?>[] completableFutureArray, int n, int n2) {
        Object object;
        CompletableFuture<?> completableFuture;
        int n3 = n + n2 >>> 1;
        CompletableFuture<Object> completableFuture2 = n == n3 ? completableFutureArray[n] : CompletableFuture.anyTree(completableFutureArray, n, n3);
        if (completableFuture2 == null || (completableFuture = n2 == n3 + 1 ? completableFutureArray[n2] : CompletableFuture.anyTree(completableFutureArray, n3 + 1, n2)) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> completableFuture3 = new CompletableFuture<Object>();
        AtomicInteger atomicInteger = null;
        CompletionNode completionNode = null;
        CompletionNode completionNode2 = null;
        while ((object = completableFuture2.result) == null && (object = completableFuture.result) == null) {
            if (atomicInteger == null) {
                atomicInteger = new OrCompletion(completableFuture2, completableFuture, completableFuture3);
                continue;
            }
            if (completionNode == null) {
                completionNode = new CompletionNode((Completion)atomicInteger);
                continue;
            }
            if (completionNode2 == null) {
                completionNode.next = completableFuture2.completions;
                if (!UNSAFE.compareAndSwapObject(completableFuture2, COMPLETIONS, completionNode.next, completionNode)) continue;
                completionNode2 = new CompletionNode((Completion)atomicInteger);
                continue;
            }
            completionNode2.next = completableFuture.completions;
            if (!UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, completionNode2.next, completionNode2)) continue;
        }
        if (!(object == null && (object = completableFuture2.result) == null && (object = completableFuture.result) == null || atomicInteger != null && !atomicInteger.compareAndSet(0, 1))) {
            Object object2;
            Throwable throwable;
            if (object instanceof AltResult) {
                throwable = ((AltResult)object).ex;
                object2 = null;
            } else {
                throwable = null;
                object2 = object;
            }
            completableFuture3.internalComplete(object2, throwable);
        }
        completableFuture2.helpPostComplete();
        completableFuture.helpPostComplete();
        return completableFuture3;
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = this.result == null && UNSAFE.compareAndSwapObject(this, RESULT, null, new AltResult(new CancellationException()));
        this.postComplete();
        return bl2 || this.isCancelled();
    }

    @Override
    public boolean isCancelled() {
        Object object = this.result;
        return object instanceof AltResult && ((AltResult)object).ex instanceof CancellationException;
    }

    public boolean isCompletedExceptionally() {
        Object object = this.result;
        return object instanceof AltResult && object != NIL;
    }

    public void obtrudeValue(T t) {
        this.result = t == null ? NIL : t;
        this.postComplete();
    }

    public void obtrudeException(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException();
        }
        this.result = new AltResult(throwable);
        this.postComplete();
    }

    public int getNumberOfDependents() {
        int n = 0;
        CompletionNode completionNode = this.completions;
        while (completionNode != null) {
            ++n;
            completionNode = completionNode.next;
        }
        return n;
    }

    public String toString() {
        int n;
        Object object = this.result;
        return super.toString() + (object == null ? ((n = this.getNumberOfDependents()) == 0 ? "[Not completed]" : "[Not completed, " + n + " dependents]") : (object instanceof AltResult && ((AltResult)object).ex != null ? "[Completed exceptionally]" : "[Completed normally]"));
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<CompletableFuture> clazz = CompletableFuture.class;
            RESULT = UNSAFE.objectFieldOffset(clazz.getDeclaredField("result"));
            WAITERS = UNSAFE.objectFieldOffset(clazz.getDeclaredField("waiters"));
            COMPLETIONS = UNSAFE.objectFieldOffset(clazz.getDeclaredField("completions"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class AcceptEither<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends T> snd;
        final Consumer<? super T> fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        AcceptEither(CompletableFuture<? extends T> completableFuture, CompletableFuture<? extends T> completableFuture2, Consumer<? super T> consumer, CompletableFuture<Void> completableFuture3, Executor executor) {
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = consumer;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            CompletableFuture<? extends T> completableFuture;
            Object object;
            CompletableFuture<? extends T> completableFuture2;
            Consumer<Object> consumer;
            CompletableFuture<Void> completableFuture3 = this.dst;
            if (completableFuture3 != null && (consumer = this.fn) != null && ((completableFuture2 = this.src) != null && (object = completableFuture2.result) != null || (completableFuture = this.snd) != null && (object = completableFuture.result) != null) && this.compareAndSet(0, 1)) {
                Object object2;
                Object object3;
                Throwable throwable;
                if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object3 = null;
                } else {
                    throwable = null;
                    object3 = object2 = object;
                }
                object2 = this.executor;
                if (throwable == null) {
                    try {
                        if (object2 != null) {
                            CompletableFuture.execAsync((Executor)object2, new AsyncAccept<T>(object3, consumer, completableFuture3));
                        } else {
                            consumer.accept(object3);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                }
                if (object2 == null || throwable != null) {
                    completableFuture3.internalComplete(null, throwable);
                }
            }
        }
    }

    static final class AltResult {
        final Throwable ex;

        AltResult(Throwable throwable) {
            this.ex = throwable;
        }
    }

    static final class AndCompletion
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AndCompletion(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, CompletableFuture<Void> completableFuture3) {
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.dst = completableFuture3;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<?> completableFuture;
            Object object2;
            CompletableFuture<?> completableFuture2;
            CompletableFuture<Void> completableFuture3 = this.dst;
            if (completableFuture3 != null && (completableFuture2 = this.src) != null && (object2 = completableFuture2.result) != null && (completableFuture = this.snd) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Throwable throwable = object2 instanceof AltResult ? ((AltResult)object2).ex : null;
                if (throwable == null && object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                }
                completableFuture3.internalComplete(null, throwable);
            }
        }
    }

    static final class ApplyToEither<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends T> snd;
        final Function<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ApplyToEither(CompletableFuture<? extends T> completableFuture, CompletableFuture<? extends T> completableFuture2, Function<? super T, ? extends U> function, CompletableFuture<U> completableFuture3, Executor executor) {
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = function;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            CompletableFuture<? extends T> completableFuture;
            Object object;
            CompletableFuture<? extends T> completableFuture2;
            Function<Object, U> function;
            CompletableFuture<U> completableFuture3 = this.dst;
            if (completableFuture3 != null && (function = this.fn) != null && ((completableFuture2 = this.src) != null && (object = completableFuture2.result) != null || (completableFuture = this.snd) != null && (object = completableFuture.result) != null) && this.compareAndSet(0, 1)) {
                Object object2;
                Object object3;
                Throwable throwable;
                if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object3 = null;
                } else {
                    throwable = null;
                    object3 = object2 = object;
                }
                object2 = this.executor;
                Object t = null;
                if (throwable == null) {
                    try {
                        if (object2 != null) {
                            CompletableFuture.execAsync((Executor)object2, new AsyncApply<T, U>(object3, function, completableFuture3));
                        } else {
                            t = function.apply(object3);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                }
                if (object2 == null || throwable != null) {
                    completableFuture3.internalComplete(t, throwable);
                }
            }
        }
    }

    static abstract class Async
    extends ForkJoinTask<Void>
    implements Runnable,
    AsynchronousCompletionTask {
        Async() {
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }

        @Override
        public final void run() {
            this.exec();
        }
    }

    static final class AsyncAccept<T>
    extends Async {
        final T arg;
        final Consumer<? super T> fn;
        final CompletableFuture<?> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncAccept(T t, Consumer<? super T> consumer, CompletableFuture<?> completableFuture) {
            this.arg = t;
            this.fn = consumer;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<?> completableFuture = this.dst;
            if (completableFuture != null && completableFuture.result == null) {
                Throwable throwable;
                try {
                    this.fn.accept(this.arg);
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                completableFuture.internalComplete(null, throwable);
            }
            return true;
        }
    }

    static final class AsyncAcceptBoth<T, U>
    extends Async {
        final T arg1;
        final U arg2;
        final BiConsumer<? super T, ? super U> fn;
        final CompletableFuture<?> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncAcceptBoth(T t, U u, BiConsumer<? super T, ? super U> biConsumer, CompletableFuture<?> completableFuture) {
            this.arg1 = t;
            this.arg2 = u;
            this.fn = biConsumer;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<?> completableFuture = this.dst;
            if (completableFuture != null && completableFuture.result == null) {
                Throwable throwable;
                try {
                    this.fn.accept(this.arg1, this.arg2);
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                completableFuture.internalComplete(null, throwable);
            }
            return true;
        }
    }

    static final class AsyncApply<T, U>
    extends Async {
        final T arg;
        final Function<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncApply(T t, Function<? super T, ? extends U> function, CompletableFuture<U> completableFuture) {
            this.arg = t;
            this.fn = function;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<U> completableFuture = this.dst;
            if (completableFuture != null && completableFuture.result == null) {
                Throwable throwable;
                U u;
                try {
                    u = this.fn.apply(this.arg);
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    u = null;
                }
                completableFuture.internalComplete(u, throwable);
            }
            return true;
        }
    }

    static final class AsyncCombine<T, U, V>
    extends Async {
        final T arg1;
        final U arg2;
        final BiFunction<? super T, ? super U, ? extends V> fn;
        final CompletableFuture<V> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncCombine(T t, U u, BiFunction<? super T, ? super U, ? extends V> biFunction, CompletableFuture<V> completableFuture) {
            this.arg1 = t;
            this.arg2 = u;
            this.fn = biFunction;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<V> completableFuture = this.dst;
            if (completableFuture != null && completableFuture.result == null) {
                Throwable throwable;
                Object t;
                try {
                    t = this.fn.apply(this.arg1, this.arg2);
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    t = null;
                }
                completableFuture.internalComplete(t, throwable);
            }
            return true;
        }
    }

    static final class AsyncCompose<T, U>
    extends Async {
        final T arg;
        final Function<? super T, ? extends CompletionStage<U>> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncCompose(T t, Function<? super T, ? extends CompletionStage<U>> function, CompletableFuture<U> completableFuture) {
            this.arg = t;
            this.fn = function;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<U> completableFuture = this.dst;
            if (completableFuture != null && completableFuture.result == null) {
                Object object;
                Throwable throwable;
                CompletableFuture<U> completableFuture2;
                Object object2;
                try {
                    object2 = this.fn.apply(this.arg);
                    completableFuture2 = object2 == null ? null : object2.toCompletableFuture();
                    throwable = completableFuture2 == null ? new NullPointerException() : null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    completableFuture2 = null;
                }
                if (throwable != null) {
                    object = null;
                } else {
                    object2 = completableFuture2.result;
                    if (object2 == null) {
                        object2 = ((CompletableFuture)completableFuture2).waitingGet(false);
                    }
                    if (object2 instanceof AltResult) {
                        throwable = ((AltResult)object2).ex;
                        object = null;
                    } else {
                        Object object3;
                        object = object3 = object2;
                    }
                }
                completableFuture.internalComplete(object, throwable);
            }
            return true;
        }
    }

    static final class AsyncRun
    extends Async {
        final Runnable fn;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncRun(Runnable runnable, CompletableFuture<Void> completableFuture) {
            this.fn = runnable;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<Void> completableFuture = this.dst;
            if (completableFuture != null && completableFuture.result == null) {
                Throwable throwable;
                try {
                    this.fn.run();
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                completableFuture.internalComplete(null, throwable);
            }
            return true;
        }
    }

    static final class AsyncSupply<U>
    extends Async {
        final Supplier<U> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncSupply(Supplier<U> supplier, CompletableFuture<U> completableFuture) {
            this.fn = supplier;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<U> completableFuture = this.dst;
            if (completableFuture != null && completableFuture.result == null) {
                Throwable throwable;
                U u;
                try {
                    u = this.fn.get();
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    u = null;
                }
                completableFuture.internalComplete(u, throwable);
            }
            return true;
        }
    }

    static final class AsyncWhenComplete<T>
    extends Async {
        final T arg1;
        final Throwable arg2;
        final BiConsumer<? super T, ? super Throwable> fn;
        final CompletableFuture<T> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncWhenComplete(T t, Throwable throwable, BiConsumer<? super T, ? super Throwable> biConsumer, CompletableFuture<T> completableFuture) {
            this.arg1 = t;
            this.arg2 = throwable;
            this.fn = biConsumer;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<T> completableFuture = this.dst;
            if (completableFuture != null && completableFuture.result == null) {
                Throwable throwable;
                block3: {
                    throwable = this.arg2;
                    try {
                        this.fn.accept(this.arg1, throwable);
                    }
                    catch (Throwable throwable2) {
                        if (throwable != null) break block3;
                        throwable = throwable2;
                    }
                }
                completableFuture.internalComplete(this.arg1, throwable);
            }
            return true;
        }
    }

    public static interface AsynchronousCompletionTask {
    }

    static abstract class Completion
    extends AtomicInteger
    implements Runnable {
        Completion() {
        }
    }

    static final class CompletionNode {
        final Completion completion;
        volatile CompletionNode next;

        CompletionNode(Completion completion) {
            this.completion = completion;
        }
    }

    static final class ExceptionCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Function<? super Throwable, ? extends T> fn;
        final CompletableFuture<T> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ExceptionCompletion(CompletableFuture<? extends T> completableFuture, Function<? super Throwable, ? extends T> function, CompletableFuture<T> completableFuture2) {
            this.src = completableFuture;
            this.fn = function;
            this.dst = completableFuture2;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<? extends T> completableFuture;
            Function<Throwable, ? super Throwable> function;
            Object object2 = null;
            Throwable throwable = null;
            CompletableFuture<Object> completableFuture2 = this.dst;
            if (completableFuture2 != null && (function = this.fn) != null && (completableFuture = this.src) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Throwable throwable2;
                if (object instanceof AltResult && (throwable2 = ((AltResult)object).ex) != null) {
                    try {
                        object2 = function.apply(throwable2);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                    }
                } else {
                    Object object3;
                    object2 = object3 = object;
                }
                completableFuture2.internalComplete(object2, throwable);
            }
        }
    }

    static final class HandleCompletion<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final BiFunction<? super T, Throwable, ? extends U> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        HandleCompletion(CompletableFuture<? extends T> completableFuture, BiFunction<? super T, Throwable, ? extends U> biFunction, CompletableFuture<U> completableFuture2, Executor executor) {
            this.src = completableFuture;
            this.fn = biFunction;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<? extends T> completableFuture;
            BiFunction<Object, Throwable, Throwable> biFunction;
            CompletableFuture<U> completableFuture2 = this.dst;
            if (completableFuture2 != null && (biFunction = this.fn) != null && (completableFuture = this.src) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Object object2;
                Object object3;
                Throwable throwable;
                if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object3 = null;
                } else {
                    throwable = null;
                    object3 = object2 = object;
                }
                object2 = this.executor;
                Object t = null;
                Throwable throwable2 = null;
                try {
                    if (object2 != null) {
                        CompletableFuture.execAsync((Executor)object2, new AsyncCombine<T, Throwable, U>(object3, throwable, biFunction, completableFuture2));
                    } else {
                        t = biFunction.apply(object3, throwable);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                }
                if (object2 == null || throwable2 != null) {
                    completableFuture2.internalComplete(t, throwable2);
                }
            }
        }
    }

    static final class OrCompletion
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final CompletableFuture<Object> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        OrCompletion(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, CompletableFuture<Object> completableFuture3) {
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.dst = completableFuture3;
        }

        @Override
        public final void run() {
            CompletableFuture<?> completableFuture;
            Object object;
            CompletableFuture<?> completableFuture2;
            CompletableFuture<Object> completableFuture3 = this.dst;
            if (completableFuture3 != null && ((completableFuture2 = this.src) != null && (object = completableFuture2.result) != null || (completableFuture = this.snd) != null && (object = completableFuture.result) != null) && this.compareAndSet(0, 1)) {
                Object object2;
                Throwable throwable;
                if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object2 = null;
                } else {
                    throwable = null;
                    object2 = object;
                }
                completableFuture3.internalComplete(object2, throwable);
            }
        }
    }

    static final class RunAfterBoth
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        RunAfterBoth(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, Runnable runnable, CompletableFuture<Void> completableFuture3, Executor executor) {
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = runnable;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<?> completableFuture;
            Object object2;
            CompletableFuture<?> completableFuture2;
            Runnable runnable;
            CompletableFuture<Void> completableFuture3 = this.dst;
            if (completableFuture3 != null && (runnable = this.fn) != null && (completableFuture2 = this.src) != null && (object2 = completableFuture2.result) != null && (completableFuture = this.snd) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Throwable throwable = object2 instanceof AltResult ? ((AltResult)object2).ex : null;
                if (throwable == null && object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                }
                Executor executor = this.executor;
                if (throwable == null) {
                    try {
                        if (executor != null) {
                            CompletableFuture.execAsync(executor, new AsyncRun(runnable, completableFuture3));
                        } else {
                            runnable.run();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                }
                if (executor == null || throwable != null) {
                    completableFuture3.internalComplete(null, throwable);
                }
            }
        }
    }

    static final class RunAfterEither
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        RunAfterEither(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, Runnable runnable, CompletableFuture<Void> completableFuture3, Executor executor) {
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = runnable;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            CompletableFuture<?> completableFuture;
            Object object;
            CompletableFuture<?> completableFuture2;
            Runnable runnable;
            CompletableFuture<Void> completableFuture3 = this.dst;
            if (completableFuture3 != null && (runnable = this.fn) != null && ((completableFuture2 = this.src) != null && (object = completableFuture2.result) != null || (completableFuture = this.snd) != null && (object = completableFuture.result) != null) && this.compareAndSet(0, 1)) {
                Throwable throwable = object instanceof AltResult ? ((AltResult)object).ex : null;
                Executor executor = this.executor;
                if (throwable == null) {
                    try {
                        if (executor != null) {
                            CompletableFuture.execAsync(executor, new AsyncRun(runnable, completableFuture3));
                        } else {
                            runnable.run();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                }
                if (executor == null || throwable != null) {
                    completableFuture3.internalComplete(null, throwable);
                }
            }
        }
    }

    static final class ThenAccept<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Consumer<? super T> fn;
        final CompletableFuture<?> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenAccept(CompletableFuture<? extends T> completableFuture, Consumer<? super T> consumer, CompletableFuture<?> completableFuture2, Executor executor) {
            this.src = completableFuture;
            this.fn = consumer;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<? extends T> completableFuture;
            Consumer<Object> consumer;
            CompletableFuture<?> completableFuture2 = this.dst;
            if (completableFuture2 != null && (consumer = this.fn) != null && (completableFuture = this.src) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Object object2;
                Object object3;
                Throwable throwable;
                if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object3 = null;
                } else {
                    throwable = null;
                    object3 = object2 = object;
                }
                object2 = this.executor;
                if (throwable == null) {
                    try {
                        if (object2 != null) {
                            CompletableFuture.execAsync((Executor)object2, new AsyncAccept<T>(object3, consumer, completableFuture2));
                        } else {
                            consumer.accept(object3);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                }
                if (object2 == null || throwable != null) {
                    completableFuture2.internalComplete(null, throwable);
                }
            }
        }
    }

    static final class ThenAcceptBoth<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends U> snd;
        final BiConsumer<? super T, ? super U> fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenAcceptBoth(CompletableFuture<? extends T> completableFuture, CompletableFuture<? extends U> completableFuture2, BiConsumer<? super T, ? super U> biConsumer, CompletableFuture<Void> completableFuture3, Executor executor) {
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = biConsumer;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<? extends U> completableFuture;
            Object object2;
            CompletableFuture<? extends T> completableFuture2;
            BiConsumer<Object, Object> biConsumer;
            CompletableFuture<Void> completableFuture3 = this.dst;
            if (completableFuture3 != null && (biConsumer = this.fn) != null && (completableFuture2 = this.src) != null && (object2 = completableFuture2.result) != null && (completableFuture = this.snd) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Object object3;
                Object object4;
                Object object5;
                Throwable throwable;
                if (object2 instanceof AltResult) {
                    throwable = ((AltResult)object2).ex;
                    object5 = null;
                } else {
                    throwable = null;
                    object5 = object4 = object2;
                }
                if (throwable != null) {
                    object3 = null;
                } else if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object3 = null;
                } else {
                    object3 = object4 = object;
                }
                object4 = this.executor;
                if (throwable == null) {
                    try {
                        if (object4 != null) {
                            CompletableFuture.execAsync((Executor)object4, new AsyncAcceptBoth<T, U>(object5, object3, biConsumer, completableFuture3));
                        } else {
                            biConsumer.accept(object5, object3);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                }
                if (object4 == null || throwable != null) {
                    completableFuture3.internalComplete(null, throwable);
                }
            }
        }
    }

    static final class ThenApply<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Function<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenApply(CompletableFuture<? extends T> completableFuture, Function<? super T, ? extends U> function, CompletableFuture<U> completableFuture2, Executor executor) {
            this.src = completableFuture;
            this.fn = function;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<? extends T> completableFuture;
            Function<Object, U> function;
            CompletableFuture<U> completableFuture2 = this.dst;
            if (completableFuture2 != null && (function = this.fn) != null && (completableFuture = this.src) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Object object2;
                Object object3;
                Throwable throwable;
                if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object3 = null;
                } else {
                    throwable = null;
                    object3 = object2 = object;
                }
                object2 = this.executor;
                Object t = null;
                if (throwable == null) {
                    try {
                        if (object2 != null) {
                            CompletableFuture.execAsync((Executor)object2, new AsyncApply<T, U>(object3, function, completableFuture2));
                        } else {
                            t = function.apply(object3);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                }
                if (object2 == null || throwable != null) {
                    completableFuture2.internalComplete(t, throwable);
                }
            }
        }
    }

    static final class ThenCombine<T, U, V>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends U> snd;
        final BiFunction<? super T, ? super U, ? extends V> fn;
        final CompletableFuture<V> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenCombine(CompletableFuture<? extends T> completableFuture, CompletableFuture<? extends U> completableFuture2, BiFunction<? super T, ? super U, ? extends V> biFunction, CompletableFuture<V> completableFuture3, Executor executor) {
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = biFunction;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<? extends U> completableFuture;
            Object object2;
            CompletableFuture<? extends T> completableFuture2;
            BiFunction<Object, Object, V> biFunction;
            CompletableFuture<V> completableFuture3 = this.dst;
            if (completableFuture3 != null && (biFunction = this.fn) != null && (completableFuture2 = this.src) != null && (object2 = completableFuture2.result) != null && (completableFuture = this.snd) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Object object3;
                Object object4;
                Object object5;
                Throwable throwable;
                if (object2 instanceof AltResult) {
                    throwable = ((AltResult)object2).ex;
                    object5 = null;
                } else {
                    throwable = null;
                    object5 = object4 = object2;
                }
                if (throwable != null) {
                    object3 = null;
                } else if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object3 = null;
                } else {
                    object3 = object4 = object;
                }
                object4 = this.executor;
                Object t = null;
                if (throwable == null) {
                    try {
                        if (object4 != null) {
                            CompletableFuture.execAsync((Executor)object4, new AsyncCombine<T, U, V>(object5, object3, biFunction, completableFuture3));
                        } else {
                            t = biFunction.apply(object5, object3);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                }
                if (object4 == null || throwable != null) {
                    completableFuture3.internalComplete(t, throwable);
                }
            }
        }
    }

    static final class ThenCompose<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Function<? super T, ? extends CompletionStage<U>> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenCompose(CompletableFuture<? extends T> completableFuture, Function<? super T, ? extends CompletionStage<U>> function, CompletableFuture<U> completableFuture2, Executor executor) {
            this.src = completableFuture;
            this.fn = function;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            CompletableFuture<U> completableFuture;
            CompletableFuture<? extends T> completableFuture2;
            Function<CompletableFuture<U>, CompletionStage<U>> function;
            CompletableFuture<U> completableFuture3 = this.dst;
            if (completableFuture3 != null && (function = this.fn) != null && (completableFuture2 = this.src) != null && (completableFuture = completableFuture2.result) != null && this.compareAndSet(0, 1)) {
                Object object;
                CompletableFuture<U> completableFuture4;
                CompletableFuture<U> completableFuture5;
                Throwable throwable;
                if (completableFuture instanceof AltResult) {
                    throwable = ((AltResult)((Object)completableFuture)).ex;
                    completableFuture5 = null;
                } else {
                    throwable = null;
                    completableFuture5 = completableFuture4 = completableFuture;
                }
                completableFuture4 = null;
                Object object2 = null;
                boolean bl = false;
                if (throwable == null) {
                    Executor executor = this.executor;
                    if (executor != null) {
                        CompletableFuture.execAsync(executor, new AsyncCompose<T, U>(completableFuture5, function, completableFuture3));
                    } else {
                        try {
                            object = function.apply(completableFuture5);
                            CompletableFuture<U> completableFuture6 = completableFuture4 = object == null ? null : object.toCompletableFuture();
                            if (completableFuture4 == null) {
                                throwable = new NullPointerException();
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                    }
                }
                if (completableFuture4 != null) {
                    Object object3;
                    object = null;
                    Object object4 = completableFuture4.result;
                    if (object4 == null) {
                        object = new ThenCopy<U>(completableFuture4, completableFuture3);
                        object3 = new CompletionNode((Completion)object);
                        while ((object4 = completableFuture4.result) == null) {
                            ((CompletionNode)object3).next = completableFuture4.completions;
                            if (!UNSAFE.compareAndSwapObject(completableFuture4, COMPLETIONS, ((CompletionNode)object3).next, object3)) continue;
                        }
                    }
                    if (object4 != null && (object == null || ((AtomicInteger)object).compareAndSet(0, 1))) {
                        bl = true;
                        if (object4 instanceof AltResult) {
                            throwable = ((AltResult)object4).ex;
                            object2 = null;
                        } else {
                            object2 = object3 = object4;
                        }
                    }
                }
                if (bl || throwable != null) {
                    completableFuture3.internalComplete(object2, throwable);
                }
                if (completableFuture4 != null) {
                    completableFuture4.helpPostComplete();
                }
            }
        }
    }

    static final class ThenCopy<T>
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<T> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenCopy(CompletableFuture<?> completableFuture, CompletableFuture<T> completableFuture2) {
            this.src = completableFuture;
            this.dst = completableFuture2;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<?> completableFuture;
            CompletableFuture<Object> completableFuture2 = this.dst;
            if (completableFuture2 != null && (completableFuture = this.src) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Object object2;
                Throwable throwable;
                if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object2 = null;
                } else {
                    Object object3;
                    throwable = null;
                    object2 = object3 = object;
                }
                completableFuture2.internalComplete(object2, throwable);
            }
        }
    }

    static final class ThenPropagate
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenPropagate(CompletableFuture<?> completableFuture, CompletableFuture<Void> completableFuture2) {
            this.src = completableFuture;
            this.dst = completableFuture2;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<?> completableFuture;
            CompletableFuture<Void> completableFuture2 = this.dst;
            if (completableFuture2 != null && (completableFuture = this.src) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Throwable throwable = object instanceof AltResult ? ((AltResult)object).ex : null;
                completableFuture2.internalComplete(null, throwable);
            }
        }
    }

    static final class ThenRun
    extends Completion {
        final CompletableFuture<?> src;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenRun(CompletableFuture<?> completableFuture, Runnable runnable, CompletableFuture<Void> completableFuture2, Executor executor) {
            this.src = completableFuture;
            this.fn = runnable;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<?> completableFuture;
            Runnable runnable;
            CompletableFuture<Void> completableFuture2 = this.dst;
            if (completableFuture2 != null && (runnable = this.fn) != null && (completableFuture = this.src) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Throwable throwable = object instanceof AltResult ? ((AltResult)object).ex : null;
                Executor executor = this.executor;
                if (throwable == null) {
                    try {
                        if (executor != null) {
                            CompletableFuture.execAsync(executor, new AsyncRun(runnable, completableFuture2));
                        } else {
                            runnable.run();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                }
                if (executor == null || throwable != null) {
                    completableFuture2.internalComplete(null, throwable);
                }
            }
        }
    }

    static final class WaitNode
    implements ForkJoinPool.ManagedBlocker {
        long nanos;
        final long deadline;
        volatile int interruptControl;
        volatile Thread thread = Thread.currentThread();
        volatile WaitNode next;

        WaitNode(boolean bl, long l, long l2) {
            this.interruptControl = bl ? 1 : 0;
            this.nanos = l;
            this.deadline = l2;
        }

        @Override
        public boolean isReleasable() {
            if (this.thread == null) {
                return true;
            }
            if (Thread.interrupted()) {
                int n = this.interruptControl;
                this.interruptControl = -1;
                if (n > 0) {
                    return true;
                }
            }
            if (this.deadline != 0L && (this.nanos <= 0L || (this.nanos = this.deadline - System.nanoTime()) <= 0L)) {
                this.thread = null;
                return true;
            }
            return false;
        }

        @Override
        public boolean block() {
            if (this.isReleasable()) {
                return true;
            }
            if (this.deadline == 0L) {
                LockSupport.park(this);
            } else if (this.nanos > 0L) {
                LockSupport.parkNanos(this, this.nanos);
            }
            return this.isReleasable();
        }
    }

    static final class WhenCompleteCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final BiConsumer<? super T, ? super Throwable> fn;
        final CompletableFuture<T> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        WhenCompleteCompletion(CompletableFuture<? extends T> completableFuture, BiConsumer<? super T, ? super Throwable> biConsumer, CompletableFuture<T> completableFuture2, Executor executor) {
            this.src = completableFuture;
            this.fn = biConsumer;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object object;
            CompletableFuture<? extends T> completableFuture;
            BiConsumer<Object, Throwable> biConsumer;
            CompletableFuture<Object> completableFuture2 = this.dst;
            if (completableFuture2 != null && (biConsumer = this.fn) != null && (completableFuture = this.src) != null && (object = completableFuture.result) != null && this.compareAndSet(0, 1)) {
                Object object2;
                Object object3;
                Throwable throwable;
                if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object3 = null;
                } else {
                    throwable = null;
                    object3 = object2 = object;
                }
                object2 = this.executor;
                Throwable throwable2 = null;
                try {
                    if (object2 != null) {
                        CompletableFuture.execAsync((Executor)object2, new AsyncWhenComplete<T>(object3, throwable, biConsumer, completableFuture2));
                    } else {
                        biConsumer.accept(object3, throwable);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                }
                if (object2 == null || throwable2 != null) {
                    completableFuture2.internalComplete(object3, throwable != null ? throwable : throwable2);
                }
            }
        }
    }
}

