/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serialize;

import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xml.internal.serialize.BaseMarkupSerializer;
import com.sun.org.apache.xml.internal.serialize.ElementState;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;
    protected boolean fNamespacePrefixes = true;
    private boolean fPreserveSpace;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream output, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(output);
    }

    @Override
    public void setOutputFormat(OutputFormat format) {
        super.setOutputFormat(format != null ? format : new OutputFormat("xml", null, false));
    }

    public void setNamespaces(boolean namespaces) {
        this.fNamespaces = namespaces;
        if (this.fNSBinder == null) {
            this.fNSBinder = new NamespaceSupport();
            this.fLocalNSBinder = new NamespaceSupport();
            this.fSymbolTable = new SymbolTable();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        boolean addNSAttr = false;
        try {
            String value;
            String name;
            String prefix;
            if (this._printer == null) {
                String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(msg);
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(localName == null || localName.length() == 0 ? rawName : localName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            attrs = this.extractNamespaces(attrs);
            if (rawName == null || rawName.length() == 0) {
                if (localName == null) {
                    String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoName", null);
                    throw new SAXException(msg);
                }
                rawName = namespaceURI != null && !namespaceURI.equals("") ? ((prefix = this.getPrefix(namespaceURI)) != null && prefix.length() > 0 ? prefix + ":" + localName : localName) : localName;
                addNSAttr = true;
            }
            this._printer.printText('<');
            this._printer.printText(rawName);
            this._printer.indent();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    void var5_12;
                    this._printer.printSpace();
                    name = attrs.getQName((int)var5_12);
                    if (name != null && name.length() == 0) {
                        name = attrs.getLocalName((int)var5_12);
                        String attrURI = attrs.getURI((int)var5_12);
                        if (!(attrURI == null || attrURI.length() == 0 || namespaceURI != null && namespaceURI.length() != 0 && attrURI.equals(namespaceURI) || (prefix = this.getPrefix(attrURI)) == null || prefix.length() <= 0)) {
                            name = prefix + ":" + name;
                        }
                    }
                    if ((value = attrs.getValue((int)var5_12)) == null) {
                        value = "";
                    }
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                    if (name.equals("xml:space")) {
                        preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++var5_12;
                }
            }
            if (this._prefixes != null) {
                Enumeration keys = this._prefixes.keys();
                while (keys.hasMoreElements()) {
                    this._printer.printSpace();
                    value = (String)keys.nextElement();
                    name = (String)this._prefixes.get(value);
                    if (name.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                }
            }
            state = this.enterElementState(namespaceURI, localName, rawName, preserveSpace);
            name = localName == null || localName.length() == 0 ? rawName : namespaceURI + "^" + localName;
            state.doCData = this._format.isCDataElement(name);
            state.unescaped = this._format.isNonEscapingElement(name);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        try {
            this.endElementIO(namespaceURI, localName, rawName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this._printer.unindent();
        ElementState state = this.getElementState();
        if (state.empty) {
            this._printer.printText("/>");
        } else {
            if (state.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !state.preserveSpace && (state.afterElement || state.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(state.rawName);
            this._printer.printText('>');
        }
        state = this.leaveElementState();
        state.afterElement = true;
        state.afterComment = false;
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startElement(String tagName, AttributeList attrs) throws SAXException {
        try {
            if (this._printer == null) {
                String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(msg);
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(tagName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(tagName);
            this._printer.indent();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    void var3_7;
                    this._printer.printSpace();
                    String name = attrs.getName((int)var3_7);
                    String value = attrs.getValue((int)var3_7);
                    if (value != null) {
                        this._printer.printText(name);
                        this._printer.printText("=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                    }
                    if (name.equals("xml:space")) {
                        preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++var3_7;
                }
            }
            state = this.enterElementState(null, null, tagName, preserveSpace);
            state.doCData = this._format.isCDataElement(tagName);
            state.unescaped = this._format.isNonEscapingElement(tagName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void endElement(String tagName) throws SAXException {
        this.endElement(null, null, tagName);
    }

    protected void startDocument(String rootTagName) throws IOException {
        String dtd = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer buffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    buffer.append(this._format.getVersion());
                } else {
                    buffer.append("1.0");
                }
                buffer.append('\"');
                String format_encoding = this._format.getEncoding();
                if (format_encoding != null) {
                    buffer.append(" encoding=\"");
                    buffer.append(format_encoding);
                    buffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    buffer.append(" standalone=\"yes\"");
                }
                buffer.append("?>");
                this._printer.printText(buffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            for (int i = 0; i < 18 + rootTagName.length(); ++i) {
                                this._printer.printText(" ");
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (dtd != null && dtd.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(dtd, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (dtd != null && dtd.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    this._printer.printText(" [");
                    this.printText(dtd, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    @Override
    protected void serializeElement(Element elem) throws IOException {
        String value;
        String name;
        Attr attr;
        int i;
        if (this.fNamespaces) {
            this.fLocalNSBinder.reset();
            this.fNSBinder.pushContext();
        }
        String tagName = elem.getTagName();
        ElementState state = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(tagName);
            }
        } else {
            if (state.empty) {
                this._printer.printText('>');
            }
            if (state.inCData) {
                this._printer.printText("]]>");
                state.inCData = false;
            }
            if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                this._printer.breakLine();
            }
        }
        this.fPreserveSpace = state.preserveSpace;
        int length = 0;
        NamedNodeMap attrMap = null;
        if (elem.hasAttributes()) {
            attrMap = elem.getAttributes();
            length = attrMap.getLength();
        }
        if (!this.fNamespaces) {
            this._printer.printText('<');
            this._printer.printText(tagName);
            this._printer.indent();
            for (i = 0; i < length; ++i) {
                attr = (Attr)attrMap.item(i);
                name = attr.getName();
                value = attr.getValue();
                if (value == null) {
                    value = "";
                }
                this.printAttribute(name, value, attr.getSpecified(), attr);
            }
        } else {
            String localpart;
            String prefix;
            boolean continueProcess;
            String msg;
            String uri;
            for (i = 0; i < length; ++i) {
                attr = (Attr)attrMap.item(i);
                uri = attr.getNamespaceURI();
                if (uri == null || !uri.equals(NamespaceContext.XMLNS_URI)) continue;
                value = attr.getNodeValue();
                if (value == null) {
                    value = XMLSymbols.EMPTY_STRING;
                }
                if (value.equals(NamespaceContext.XMLNS_URI)) {
                    if (this.fDOMErrorHandler == null) continue;
                    msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CantBindXMLNS", null);
                    this.modifyDOMError(msg, (short)2, null, attr);
                    continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                    if (continueProcess) continue;
                    throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SerializationStopped", null));
                }
                prefix = attr.getPrefix();
                prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                if (prefix == XMLSymbols.PREFIX_XMLNS) {
                    if ((value = this.fSymbolTable.addSymbol(value)).length() == 0) continue;
                    this.fNSBinder.declarePrefix(localpart, value);
                    continue;
                }
                value = this.fSymbolTable.addSymbol(value);
                this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, value);
            }
            uri = elem.getNamespaceURI();
            prefix = elem.getPrefix();
            if (uri != null && prefix != null && uri.length() == 0 && prefix.length() != 0) {
                prefix = null;
                this._printer.printText('<');
                this._printer.printText(elem.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(tagName);
                this._printer.indent();
            }
            if (uri != null) {
                uri = this.fSymbolTable.addSymbol(uri);
                String string = prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                if (this.fNSBinder.getURI(prefix) != uri) {
                    if (this.fNamespacePrefixes) {
                        this.printNamespaceAttr(prefix, uri);
                    }
                    this.fLocalNSBinder.declarePrefix(prefix, uri);
                    this.fNSBinder.declarePrefix(prefix, uri);
                }
            } else if (elem.getLocalName() == null) {
                if (this.fDOMErrorHandler != null) {
                    msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{elem.getNodeName()});
                    this.modifyDOMError(msg, (short)2, null, elem);
                    continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                    if (!continueProcess) {
                        throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SerializationStopped", null));
                    }
                }
            } else {
                uri = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                if (uri != null && uri.length() > 0) {
                    if (this.fNamespacePrefixes) {
                        this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    }
                    this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                }
            }
            for (i = 0; i < length; ++i) {
                attr = (Attr)attrMap.item(i);
                value = attr.getValue();
                name = attr.getNodeName();
                uri = attr.getNamespaceURI();
                if (uri != null && uri.length() == 0) {
                    uri = null;
                    name = attr.getLocalName();
                }
                if (value == null) {
                    value = XMLSymbols.EMPTY_STRING;
                }
                if (uri != null) {
                    prefix = attr.getPrefix();
                    prefix = prefix == null ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                    localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (uri != null && uri.equals(NamespaceContext.XMLNS_URI)) {
                        String localUri;
                        prefix = attr.getPrefix();
                        prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                        localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (prefix == XMLSymbols.PREFIX_XMLNS) {
                            localUri = this.fLocalNSBinder.getURI(localpart);
                            if ((value = this.fSymbolTable.addSymbol(value)).length() == 0 || localUri != null) continue;
                            if (this.fNamespacePrefixes) {
                                this.printNamespaceAttr(localpart, value);
                            }
                            this.fLocalNSBinder.declarePrefix(localpart, value);
                            continue;
                        }
                        uri = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                        localUri = this.fLocalNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                        value = this.fSymbolTable.addSymbol(value);
                        if (localUri != null || !this.fNamespacePrefixes) continue;
                        this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, value);
                        continue;
                    }
                    uri = this.fSymbolTable.addSymbol(uri);
                    String declaredURI = this.fNSBinder.getURI(prefix);
                    if (prefix == XMLSymbols.EMPTY_STRING || declaredURI != uri) {
                        name = attr.getNodeName();
                        String declaredPrefix = this.fNSBinder.getPrefix(uri);
                        if (declaredPrefix != null && declaredPrefix != XMLSymbols.EMPTY_STRING) {
                            prefix = declaredPrefix;
                            name = prefix + ":" + localpart;
                        } else {
                            if (prefix == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(prefix) != null) {
                                int counter = 1;
                                prefix = this.fSymbolTable.addSymbol(PREFIX + counter++);
                                while (this.fLocalNSBinder.getURI(prefix) != null) {
                                    prefix = this.fSymbolTable.addSymbol(PREFIX + counter++);
                                }
                                name = prefix + ":" + localpart;
                            }
                            if (this.fNamespacePrefixes) {
                                this.printNamespaceAttr(prefix, uri);
                            }
                            value = this.fSymbolTable.addSymbol(value);
                            this.fLocalNSBinder.declarePrefix(prefix, value);
                            this.fNSBinder.declarePrefix(prefix, uri);
                        }
                    }
                    this.printAttribute(name, value == null ? XMLSymbols.EMPTY_STRING : value, attr.getSpecified(), attr);
                    continue;
                }
                if (attr.getLocalName() == null) {
                    if (this.fDOMErrorHandler != null) {
                        msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr.getNodeName()});
                        this.modifyDOMError(msg, (short)2, null, attr);
                        boolean continueProcess2 = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!continueProcess2) {
                            throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SerializationStopped", null));
                        }
                    }
                    this.printAttribute(name, value, attr.getSpecified(), attr);
                    continue;
                }
                this.printAttribute(name, value, attr.getSpecified(), attr);
            }
        }
        if (elem.hasChildNodes()) {
            state = this.enterElementState(null, null, tagName, this.fPreserveSpace);
            state.doCData = this._format.isCDataElement(tagName);
            state.unescaped = this._format.isNonEscapingElement(tagName);
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.serializeNode(child);
            }
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this.endElementIO(null, null, tagName);
        } else {
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this._printer.unindent();
            this._printer.printText("/>");
            state.afterElement = true;
            state.afterComment = false;
            state.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String prefix, String uri) throws IOException {
        this._printer.printSpace();
        if (prefix == XMLSymbols.EMPTY_STRING) {
            this._printer.printText(XMLSymbols.PREFIX_XMLNS);
        } else {
            this._printer.printText("xmlns:" + prefix);
        }
        this._printer.printText("=\"");
        this.printEscaped(uri);
        this._printer.printText('\"');
    }

    private void printAttribute(String name, String value, boolean isSpecified, Attr attr) throws IOException {
        if (isSpecified || (this.features & 0x40) == 0) {
            if (this.fDOMFilter != null && (this.fDOMFilter.getWhatToShow() & 2) != 0) {
                short code = this.fDOMFilter.acceptNode(attr);
                switch (code) {
                    case 2: 
                    case 3: {
                        return;
                    }
                }
            }
            this._printer.printSpace();
            this._printer.printText(name);
            this._printer.printText("=\"");
            this.printEscaped(value);
            this._printer.printText('\"');
        }
        if (name.equals("xml:space")) {
            this.fPreserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    @Override
    protected String getEntityRef(int ch) {
        switch (ch) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attrs) throws SAXException {
        if (attrs == null) {
            return null;
        }
        int length = attrs.getLength();
        AttributesImpl attrsOnly = new AttributesImpl(attrs);
        for (int i = length - 1; i >= 0; --i) {
            String rawName = attrsOnly.getQName(i);
            if (!rawName.startsWith("xmlns")) continue;
            if (rawName.length() == 5) {
                this.startPrefixMapping("", attrs.getValue(i));
                attrsOnly.removeAttribute(i);
                continue;
            }
            if (rawName.charAt(5) != ':') continue;
            this.startPrefixMapping(rawName.substring(6), attrs.getValue(i));
            attrsOnly.removeAttribute(i);
        }
        return attrsOnly;
    }

    @Override
    protected void printEscaped(String source) throws IOException {
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (!XMLChar.isValid(ch)) {
                if (++i < length) {
                    this.surrogates(ch, source.charAt(i));
                    continue;
                }
                this.fatalError("The character '" + (char)ch + "' is an invalid XML character");
                continue;
            }
            if (ch == '\n' || ch == '\r' || ch == '\t') {
                this.printHex(ch);
                continue;
            }
            if (ch == '<') {
                this._printer.printText("&lt;");
                continue;
            }
            if (ch == '&') {
                this._printer.printText("&amp;");
                continue;
            }
            if (ch == '\"') {
                this._printer.printText("&quot;");
                continue;
            }
            if (ch >= ' ' && this._encodingInfo.isPrintable(ch)) {
                this._printer.printText(ch);
                continue;
            }
            this.printHex(ch);
        }
    }

    protected void printXMLChar(int ch) throws IOException {
        if (ch == 13) {
            this.printHex(ch);
        } else if (ch == 60) {
            this._printer.printText("&lt;");
        } else if (ch == 38) {
            this._printer.printText("&amp;");
        } else if (ch == 62) {
            this._printer.printText("&gt;");
        } else if (ch == 10 || ch == 9 || ch >= 32 && this._encodingInfo.isPrintable((char)ch)) {
            this._printer.printText((char)ch);
        } else {
            this.printHex(ch);
        }
    }

    @Override
    protected void printText(String text, boolean preserveSpace, boolean unescaped) throws IOException {
        int length = text.length();
        if (preserveSpace) {
            for (int index = 0; index < length; ++index) {
                char ch = text.charAt(index);
                if (!XMLChar.isValid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index));
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        } else {
            for (int index = 0; index < length; ++index) {
                char ch = text.charAt(index);
                if (!XMLChar.isValid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index));
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        }
    }

    @Override
    protected void printText(char[] chars, int start, int length, boolean preserveSpace, boolean unescaped) throws IOException {
        if (preserveSpace) {
            while (length-- > 0) {
                char ch;
                if (!XMLChar.isValid(ch = chars[start++])) {
                    if (length-- > 0) {
                        this.surrogates(ch, chars[start++]);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        } else {
            while (length-- > 0) {
                char ch;
                if (!XMLChar.isValid(ch = chars[start++])) {
                    if (length-- > 0) {
                        this.surrogates(ch, chars[start++]);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        }
    }

    @Override
    protected void checkUnboundNamespacePrefixedNode(Node node) throws IOException {
        if (this.fNamespaces) {
            Node child = node.getFirstChild();
            while (child != null) {
                Node next = child.getNextSibling();
                String prefix = child.getPrefix();
                String string = prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                if (this.fNSBinder.getURI(prefix) == null && prefix != null) {
                    this.fatalError("The replacement text of the entity node '" + node.getNodeName() + "' contains an element node '" + child.getNodeName() + "' with an undeclared prefix '" + prefix + "'.");
                }
                if (child.getNodeType() == 1) {
                    NamedNodeMap attrs = child.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String attrPrefix = attrs.item(i).getPrefix();
                        String string2 = attrPrefix = attrPrefix == null || attrPrefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(attrPrefix);
                        if (this.fNSBinder.getURI(attrPrefix) != null || attrPrefix == null) continue;
                        this.fatalError("The replacement text of the entity node '" + node.getNodeName() + "' contains an element node '" + child.getNodeName() + "' with an attribute '" + attrs.item(i).getNodeName() + "' an undeclared prefix '" + attrPrefix + "'.");
                    }
                }
                if (child.hasChildNodes()) {
                    this.checkUnboundNamespacePrefixedNode(child);
                }
                child = next;
            }
        }
    }

    @Override
    public boolean reset() {
        super.reset();
        if (this.fNSBinder != null) {
            this.fNSBinder.reset();
            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        }
        return true;
    }
}

